<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_careers_shortcode_vc');
function investment_careers_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Career', 'investment'),
			'base' => 'investment_career',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Display all job',
			'params' => array(				
				array(
					'type' => 'number',
					'heading' => __('Display', 'investment'),
					'param_name' => 'posts_per_page',
					'description' => '-1 to display all jobs',
					'value' => '-1',
					'min' => '-1',
					'max' => '50',
					'step' => '1',
					'admin_label' => true,
				),
				array(
					'type' => 'checkbox',
					'param_name' => 'display_location',
					'value' => array( __( 'Display job location?', 'investment' ) => 'yes' )	,
					'std' => 'yes',	
				),
				array(
					'type' => 'checkbox',
					'param_name' => 'display_department',
					'value' => array( __( 'Display job department?', 'investment' ) => 'yes' )	,
					'std' => 'yes',	
				),
				
				array(
					'type' => 'checkbox',
					'param_name' => 'display_type',
					'value' => array( __( 'Display job type?', 'investment' ) => 'yes' )	,
				),
				array(
					'type' => 'checkbox',
					'param_name' => 'display_sallary',
					'value' => array( __( 'Display Sallary information?', 'investment' ) => 'yes' )	,
				),
				array(
					'type' => 'checkbox',
					'param_name' => 'display_vacancy',
					'value' => array( __( 'Display job Vacancy?', 'investment' ) => 'yes' )	,
				),
				array(
					'type' => 'checkbox',
					'param_name' => 'display_date',
					'value' => array( __( 'Display job post date?', 'investment' ) => 'yes' )	,
					'std' => 'yes',	
				),
			)
		) 
	);
	
}

class WPBakeryShortCode_Investment_career extends WPBakeryShortCode {
}