<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_company_summary_shortcode_vc');
function investment_company_summary_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Company summary', 'investment'),
			'base' => 'investment_company_summary',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'category' => __('Investment', 'investment'),
			'description' => 'Company introduction and figure block',
			'params' => array(	
				array(
					'type' => 'dropdown',
					'heading' => __('Lead text alignment', 'investment'),
					'param_name' => 'lead_text_align',
					'value' =>  array_flip(array(
								'' => __( 'Initial', 'investment' ),
								'text-start' => __( 'Left', 'investment' ),
								'text-center' => __( 'Center', 'investment' ),
								'text-end' => __( 'Right', 'investment' ),
								'text-justify' => __( 'Justify', 'investment' ),
							)),
					'group' => 'Company history'
				),
				array(
					'type' => 'textarea',
					'heading' => __('Lead text', 'investment'),
					'param_name' => 'lead_text',
					'value' => '<b>Founded in 1980,</b> Investment Expert is one of the largest and most experienced global private equity firms. We have established a team investment professionals, focused on buyouts and growth equity investments.',
					'admin_label' => true,
					'save_always' => true,
					'group' => 'Company history'
				),	
				array(
					'type' => 'textarea_html',
					'heading' => __('Description', 'investment'),
					'param_name' => 'content',
					'value' => '<p class="excerpt_normal">
						We employ a long-established strategy of sector-focused investing across all of our markets.</p><p class="normal">We seek to invest in well-positioned companies with strategic improvement potential and partner with management teams to create value by driving revenue and earnings growth.</p>',
					'admin_label' => true,
					'group' => 'Company history'
				),
				array(
			      'type' => 'dropdown',
			      'group' => 'Figure block',
			      'heading' => __( 'Hide label area?', 'investment' ),
			      'param_name' => 'hide_label',
			      'description' => __( 'If yes, label area will be hide in Company summary.', 'investment' ),
			      'value' => array(
		            __( 'No', 'investment' ) => 'no',
		            __( 'Yes', 'investment' ) => 'yes',
		          ),
			    ),
				array(
					'type' => 'textfield',
					'heading' => __('Label Title', 'investment'),
					'param_name' => 'label_title',
					'value' => 'Middle-market private equity',
					'admin_label' => true,
					'group' => 'Figure block',
					'dependency' => array(
			          'element' => 'hide_label',
			          'value' => array('no'),
			        ),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Label large text', 'investment'),
					'param_name' => 'label_large',
					'value' => 'EWT',
					'admin_label' => true,
					'group' => 'Figure block',
					'dependency' => array(
			          'element' => 'hide_label',
			          'value' => array('no'),
			        ),
				),	
				array(
					'type' => 'textfield',
					'heading' => __('Label description', 'investment'),
					'param_name' => 'label_desc',
					'description' => 'Use {} to highlight text',
					'value' => '{12} Offices in {11} Countries',
					'admin_label' => true,
					'group' => 'Figure block',
					'dependency' => array(
			          'element' => 'hide_label',
			          'value' => array('no'),
			        ),
				),
				array(
			      'type' => 'dropdown',
			      'group' => 'Figure block',
			      'heading' => __( 'Hide value area?', 'investment' ),
			      'param_name' => 'hide_value',
			      'description' => __( 'If yes, value area will be hide in Company summary.', 'investment' ),
			      'value' => array(
		            __( 'No', 'investment' ) => 'no',
		            __( 'Yes', 'investment' ) => 'yes',
		          ),
			    ),
				array(
					'type' => 'textfield',
					'heading' => __('Value Title', 'investment'),
					'param_name' => 'value_title',
					'value' => 'Invested',
					'group' => 'Figure block',
					'dependency' => array(
			          'element' => 'hide_value',
			          'value' => array('no'),
			        ),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Value large text', 'investment'),
					'param_name' => 'value_large',
					'value' => '$2.4',
					'admin_label' => true,
					'group' => 'Figure block',
					'dependency' => array(
			          'element' => 'hide_value',
			          'value' => array('no'),
			        ),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Value unit', 'investment'),
					'param_name' => 'value_unit',
					'value' => 'B',
					'admin_label' => true,
					'group' => 'Figure block',
					'dependency' => array(
			          'element' => 'hide_value',
			          'value' => array('no'),
			        ),
				),
				array(
					'type' => 'dropdown',
					'group' => 'Figure block',
					'heading' => __( 'Horizontal gap', 'investment' ),
					'param_name' => 'horizontal_gap',
					'description' => '',
					'value' => array(
					  __( 'Default', 'investment' ) => '',
					  __( '5px', 'investment' ) => '5',
					  __( '10px', 'investment' ) => '10',
					  __( '15px', 'investment' ) => '15',
					  __( '20px', 'investment' ) => '20',
					  __( '25px', 'investment' ) => '25',
					  __( '30px', 'investment' ) => '30',
					  __( '40px', 'investment' ) => '40',
					  __( '45px', 'investment' ) => '45',
					  __( '50px', 'investment' ) => '50',
					),
				  ),			
				),
		) 
	);

	
	
}
class WPBakeryShortCode_Investment_company_summary extends WPBakeryShortCode {
}