<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_featured_box_shortcode_vc');
function investment_featured_box_shortcode_vc() {
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Featured box', 'investment'),
			'base' => 'investment_featured_box',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Show fetured image and heading with different style',			
			'params' => array(
				array(
					'type' => 'perch_select',
					'heading' => __('Background type', 'investment'),
					'param_name' => 'bg_type',
					'value' =>  array(
								'bg_gray' => __( 'Default', 'investment' ),
								'primary-bg' => __( 'Primary color', 'investment' ),
								'secondary-bg-dark' => __( 'Secondary color', 'investment' ),
							),
				),				
				array(
					'type' => 'checkbox',
					'heading' => __( 'Use custom featured image?', 'investment' ),
					'param_name' => 'add_custom_image',
					'description' => __( 'Default display featured image', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'yes' )					
				),
				array(
	                'type' => 'image_upload',
	                'value' => '',
	                'heading' => 'Custom featured image',
	                'param_name' => 'image',
	                'dependency' => array(
						'element' => 'add_custom_image',
						'value' => array( 'yes')
					),
	            ),
	            array(
					'type' => 'checkbox',
					'heading' => __( 'Show image in right?', 'investment' ),
					'param_name' => 'image_right',
					'description' => __( 'Default image display in left', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'order-sm-2' )					
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Heading tag', 'investment'),
					'param_name' => 'tag',
					'save_always' => true,
					'value' =>  array(
								'h1' => __( 'H1', 'investment' ),
								'h2' => __( 'H2', 'investment' ),
								'h3' => __( 'H3', 'investment' ),
								'h4' => __( 'H4', 'investment' ),
								'h5' => __( 'H5', 'investment' ),
								'h6' => __( 'H6', 'investment' ),
							),
					'selected' => 'h4'
				),
				array(
					'type' => 'textfield',
					'heading' => __('Heading Title', 'investment'),
					'param_name' => 'title',
					'description' => 'use {} for highlight text',
					'value' => 'Increase Profitability',
					'admin_label' => true
				),
				array(
					'type' => 'checkbox',
					'heading' => __( 'Add underline?', 'investment' ),
					'param_name' => 'add_underline',
					'description' => __( 'Display underline after title', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
					'std' => 'yes'					
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Underline style', 'investment' ),
					'param_name' => 'style',
					'value' => array(
						__( 'Thin', 'investment' ) => 'underline-primary',
						__( 'Bold', 'investment' ) => 'underline_small',
					),
					'std' => 'underline_small',
					'dependency' => array(
						'element' => 'add_underline',
						'value' => array( 'yes')
					),
				),
				array(
					'type' => 'textarea_html',
					'heading' => __('Description', 'investment'),
					'param_name' => 'content',
					'description' => '',
					'value' => '<p>“We seek to invest in well positioned companies with strategic improvement potential and partner with management teams to create value by driving revenue and earnings growth.”</p><br><br>
					<img class="signature" src="'.INVESTMENT_ASSETS.'/images/service/signature.png" alt="image">',
					'admin_label' => true
				),
			),	

	));
	
}

class WPBakeryShortCode_Investment_featured_box extends WPBakeryShortCode {
}