<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_figures_block_shortcode_vc');
function investment_figures_block_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Figures block', 'investment'),
			'base' => 'investment_figures_block',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Highlight figure with color background',
			'params' => array(	
				array(
					'type' => 'checkbox',
					'heading' => __( 'Display in a row', 'investment' ),
					'param_name' => 'type',
					'description' => __( 'Display in a row or up-down style', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'yes' )					
				), 
				array(
			      'type' => 'dropdown',
			      'heading' => __( 'Hide label area?', 'investment' ),
			      'param_name' => 'hide_label',
			      'description' => __( 'If yes, label area will be hide in Company summary.', 'investment' ),
			      'value' => array(
		            __( 'No', 'investment' ) => 'no',
		            __( 'Yes', 'investment' ) => 'yes',
		          ),
			    ),
				array(
					'type' => 'textfield',
					'heading' => __('Label Title', 'investment'),
					'param_name' => 'label_title',
					'value' => 'Middle-market private equity',
					'admin_label' => true,
					'dependency' => array(
			          'element' => 'hide_label',
			          'value' => array('no'),
			        ),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Label large text', 'investment'),
					'param_name' => 'label_large',
					'value' => 'EWT',
					'admin_label' => true,
					'dependency' => array(
			          'element' => 'hide_label',
			          'value' => array('no'),
			        ),
				),	
				array(
					'type' => 'textfield',
					'heading' => __('Label description', 'investment'),
					'param_name' => 'label_desc',
					'description' => 'Use {} to highlight text',
					'value' => '{12} Offices in {11} Countries',
					'admin_label' => true,
					'dependency' => array(
			          'element' => 'hide_label',
			          'value' => array('no'),
			        ),
				),
				array(
			      'type' => 'dropdown',
			      'heading' => __( 'Hide value area?', 'investment' ),
			      'param_name' => 'hide_value',
			      'description' => __( 'If yes, value area will be hide in Company summary.', 'investment' ),
			      'value' => array(
		            __( 'No', 'investment' ) => 'no',
		            __( 'Yes', 'investment' ) => 'yes',
		          ),
			    ),
				array(
					'type' => 'textfield',
					'heading' => __('Value Title', 'investment'),
					'param_name' => 'value_title',
					'value' => 'Invested',
					'dependency' => array(
			          'element' => 'hide_value',
			          'value' => array('no'),
			        ),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Value large text', 'investment'),
					'param_name' => 'value_large',
					'value' => '$2.4',
					'admin_label' => true,
					'dependency' => array(
			          'element' => 'hide_value',
			          'value' => array('no'),
			        ),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Value unit', 'investment'),
					'param_name' => 'value_unit',
					'value' => 'B',
					'admin_label' => true,
					'dependency' => array(
			          'element' => 'hide_value',
			          'value' => array('no'),
			        ),
				),
				
			)
		) 
	);
	
}
class WPBakeryShortCode_Investment_figures_block extends WPBakeryShortCode {
}
