<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_get_in_touch_shortcode_vc');
function investment_get_in_touch_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Contact info', 'investment'),
			'base' => 'investment_contact_info',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => '',
			'params' => array(	
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'description' => '',
					'value' => 'Get in Touch',
					'admin_label' => true,
				),
				array(
					'type' => 'attach_image',
					'heading' => __('Image', 'investment'),
					'param_name' => 'image',
					'description' => 'Optional',
					'admin_label' => true,
					
				),	
				array(
					'type' => 'textarea',
					'heading' => __('Address', 'investment'),
					'param_name' => 'address',
					'description' => '',
					'value' => '70 W. Madison Street, Ste. 1400 Chicago, IL 60602',
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Phone', 'investment'),
					'param_name' => 'phone',
					'description' => 'Multiple values are comma(,) separated',
					'value' => '(214) 550-0405',
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Fax', 'investment'),
					'param_name' => 'fax',
					'description' => 'Multiple values are comma(,) separated',
					'value' => '(290) 580-9595',
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Email', 'investment'),
					'param_name' => 'email',
					'description' => 'Multiple values are comma(,) separated',
					'value' => 'info@themeperch.net',
					'admin_label' => true,
				),
				// params group
	            array(
	                'type' => 'param_group',
	                'save_always' => true,
	                'heading' => __( 'List info', 'investment' ),
	                'param_name' => 'list_info',
	                'value' => '',
	                'params' => array(  
	                	array(
							'type' => 'textfield',
							'heading' => __('List title', 'investment'),
							'param_name' => 'list_title',
							'description' => '',
							'value' => '',
							'admin_label' => true,
						),	                
						array(
			                'type' => 'exploded_textarea',
			                'value' => '',
			                'description' => 'Multiple values are comma(,) separated',
			                'heading' => 'List info',
			                'param_name' => 'list_info',
			            ),
			            
	                   
	                )
	            ),
			)
		) 
	);
	
}
class WPBakeryShortCode_Investment_contact_info extends WPBakeryShortCode {
}