<?php

/**
 * The VC Functions
 */
add_action('vc_before_init', 'investment_google_map_shortcode_vc');

function investment_google_map_shortcode_vc() {

    vc_map(
            array(
                'icon' => 'investment-icon',
                'name' => __('Google map', 'investment'),
                'base' => 'investment_google_map',
                'class' => 'investment-vc',
                'category' => __('Investment', 'investment'),
                'description' => 'Multiple map show as tab',
                'save_always' => true,
                'params' => array(
                    // params group
                    array(
                        'type' => 'param_group',
                        'heading' => __('Maps Info', 'investment'),
                        'param_name' => 'mapsinfo',
                        'value' => urlencode(json_encode(array(
                            array(
                                'style' => 'default',
                                'title' => 'Chicago Office',
                                'lat' => 41.506146,
                                'long' => -87.6355995,
                                'zoom' => 12,
                                'marker' => INVESTMENT_ASSETS . '/images/map-marker.png',
                            ),
                            array(
                                'style' => 'default',
                                'title' => 'Washington Office',
                                'lat' => 38.9071923,
                                'long' => -77.0368707,
                                'zoom' => 12,
                                'marker' => INVESTMENT_ASSETS . '/images/map-marker.png'
                            ),
                            array(
                                'style' => 'default',
                                'title' => 'New York Office',
                                'lat' => 40.7127837,
                                'long' => -74.0059413,
                                'zoom' => 12,
                                'marker' => INVESTMENT_ASSETS . '/images/map-marker.png',
                            ),
                            array(
                                'style' => 'default',
                                'title' => 'London Office',
                                'lat' => 51.5073509,
                                'long' => -0.1277583,
                                'zoom' => 12,
                                'marker' => INVESTMENT_ASSETS . '/images/map-marker.png',
                            ),
                        ))),
                        'params' => array(
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_attr__('Display Type', 'investment'),
                                'param_name' => 'style',
                                'value' => array(
                                    'Default' => 'default',
                                    'Iframe' => 'embaed',
                                ),
                                'edit_field_class' => 'vc_col-sm-6',
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => __('Title', 'investment'),
                                'param_name' => 'title',
                                'description' => '',
                                'value' => '',
                                'admin_label' => true
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => __('Latitude', 'investment'),
                                'param_name' => 'lat',
                                'description' => '',
                                'value' => '',
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => __('Longitude', 'investment'),
                                'param_name' => 'long',
                                'description' => '',
                                'value' => '',
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' => __('Zoom', 'investment'),
                                'param_name' => 'zoom',
                                'description' => '',
                                'value' => '',
                            ),
                            array(
                                'type' => 'image_upload',
                                'value' => INVESTMENT_ASSETS . '/images/map-marker.png',
                                'heading' => 'Marker',
                                'param_name' => 'marker',
                            ),
                        )
                    ),
                )
            )
    );
}

class WPBakeryShortCode_Investment_google_map extends WPBakeryShortCode {
    
}
