<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_header_content_shortcode_vc');
function investment_header_content_shortcode_vc() {
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Header content', 'investment'),
			'base' => 'investment_header_content',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Display Title, subtitle and button',
			
			'params' => array(	
				array(
					'type' => 'perch_select',
					'heading' => __('Content Style', 'investment'),
					'param_name' => 'style',
					'save_always' => true,
					'value' =>  array(
								'style1' => __( 'Style 1', 'investment' ),
								'style2' => __( 'Style 2', 'investment' ),
								'style3' => __( 'Style 3', 'investment' ),
							),
				),	
				array(
					'type' => 'perch_select',
					'heading' => __('Content alignment', 'investment'),
					'param_name' => 'align',
					'value' =>  array(
								'text-left' => __( 'Left', 'investment' ),
								'text-center' => __( 'Center', 'investment' ),
							),
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Title tag', 'investment'),
					'param_name' => 'title_tag',
					'save_always' => true,
					'value' =>  array(
								'' 	 => __( 'Default', 'investment' ),
								'h1' => __( 'H1', 'investment' ),
								'h2' => __( 'H2', 'investment' ),
								'h3' => __( 'H3', 'investment' ),
								'h4' => __( 'H4', 'investment' ),
								'h5' => __( 'H5', 'investment' ),
								'h6' => __( 'H6', 'investment' ),
					),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Title font size', 'investment'),
					'description' => __('Display uses for larger font size', 'investment'),
					'param_name' => 'title_font_size',
					'save_always' => true,
					'value' =>  array(
								'' 			=> __( 'Default', 'investment' ),
								'display-1' => __( 'Display 1', 'investment' ),
								'display-2' => __( 'Display 2', 'investment' ),
								'display-3' => __( 'Display 3', 'investment' ),
								'display-4' => __( 'Display 4', 'investment' ),
								'display-5' => __( 'Display 5', 'investment' ),
								'display-6' => __( 'Display 6', 'investment' ),
								'fs-1' => __( 'H1 font size', 'investment' ),
								'fs-2' => __( 'H2 font size', 'investment' ),
								'fs-3' => __( 'H3 font size', 'investment' ),
								'fs-4' => __( 'H4 font size', 'investment' ),
								'fs-5' => __( 'H5 font size', 'investment' ),
								'fs-6' => __( 'H6 font size', 'investment' ),
					),
					'edit_field_class' => 'vc_col-sm-6',
				),			
				array(
					'type' => 'textarea',
					'heading' => __('Heading Title', 'investment'),
					'param_name' => 'title',
					'description' => 'use {} for highlight text',
					'value' => 'Investment Expert is one of the largest and most experienced global private equity investors',
					'admin_label' => true
				),
				array(
					'type' => 'textarea',
					'heading' => __('Heading sub-title', 'investment'),
					'param_name' => 'subtitle',
					'description' => 'use {} for highlight text',
					'value' => 'Middle-market private equity',
					'admin_label' => true
				),
				array(
					'type' => 'textarea',
					'heading' => __('Description', 'investment'),
					'param_name' => 'desc',
					'description' => 'use {} for highlight text',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button title', 'investment'),
					'param_name' => 'button_text',
					'value' => 'Find out more',
					'admin_label' => true
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button url', 'investment'),
					'param_name' => 'button_url',
					'value' => '#',
				),
				
			),	

	));
	
}

class WPBakeryShortCode_Investment_header_content extends WPBakeryShortCode {
}