<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_list_item_shortcode_vc');
function investment_list_item_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('List item', 'investment'),
			'base' => 'investment_list_item',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => '',
			'params' => array(					
				array(
					'type' => 'checkbox',
					'heading' => __( 'Add icon?', 'investment' ),
					'param_name' => 'add_icon',
					'description' => __( 'Display icon before title', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
					'edit_field_class' => 'vc_col-sm-6',					
				),
				array(
					'type' => 'checkbox',
					'heading' => __( 'Icon background?', 'investment' ),
					'param_name' => 'icon_bg',
					'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
					'std' => 'yes',	
					'dependency' => array(
						'element' => 'add_icon',
						'value' => array( 'yes')
					),	
					'edit_field_class' => 'vc_col-sm-6',				
				),
				array(
		          'type' => 'dropdown',
		          'heading' => __('Icon type', 'investment'),
		          'param_name' => 'type',
		          'description' => '',
		          'value' => array(
		                'Perch'  => 'perch',
		                'Pixden'  => 'pixden',
		                'Linecons' => 'linecons',
		                'Entypo' => 'entypo',
		                'Typicons' => 'typicons',
		                'Openiconic' => 'openiconic',
		                'Fontawesome' => 'fontawesome',                
		              ),
		          'dependency' => array(
						'element' => 'add_icon',
						'value' => array( 'yes')
					),
		        ),
            	investment_vc_icon_set('perch', 'icon_perch', 'perch perch-value', 'type'  ),	
            	investment_vc_icon_set('pixden', 'icon_pixden', '', 'type'  ),                
            	investment_vc_icon_set('linecons', 'icon_linecons', '', 'type'  ),         
            	investment_vc_icon_set('entypo', 'icon_entypo', '', 'type'  ), 
            	investment_vc_icon_set('typicons', 'icon_typicons', '', 'type'  ),       
            	investment_vc_icon_set('openiconic', 'icon_openiconic', '', 'type'  ),       
            	investment_vc_icon_set('fontawesome', 'icon_fontawesome', '', 'type'  ), 
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'description' => 'Use {} to highlight text',
					'value' => 'Investment Deal Team',
					'admin_label' => true,
					'edit_field_class' => 'vc_col-sm-7',
				),	
				array(
					'type' => 'perch_select',
					'heading' => __('Title style', 'investment'),
					'param_name' => 'style',
					'save_always' => true,
					'value' =>  array(
								'normal' => __( 'Normal', 'investment' ),
								'h_small' => __( 'Bold', 'investment' ),
								'h4' => __( 'H4', 'investment' ),
								'h5' => __( 'H5', 'investment' ),
								'h6' => __( 'H6', 'investment' ),
							),
					'edit_field_class' => 'vc_col-sm-3',
				),
				array(
					'type' => 'checkbox',
					'heading' => __( 'Add Link?', 'investment' ),
					'param_name' => 'add_link',
					'description' => __( 'Enable title link', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
					'edit_field_class' => 'vc_col-sm-2',	
					'admin_label' => true,				
				),
				array(
					'type' => 'textfield',
					'heading' => __('Link', 'investment'),
					'param_name' => 'title_link',
					'value' => '#',		
					'dependency' => array( 'element' => 'add_link', 'value' => array( 'yes')),		
					
				),
	            array(
	                'type' => 'textarea',
	                'value' => '',
	                'heading' => 'Description',
	                'param_name' => 'desc',
	                'description' => 'Leave blank to avoid this area',
	                'admin_label' => true,
	            ),
				
			)
		) 
	);
	
}
class WPBakeryShortCode_Investment_list_item extends WPBakeryShortCode {
}
