<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_onepage_header_info_shortcode_vc');
function investment_onepage_header_info_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Onepage header info', 'investment'),
			'base' => 'investment_onepage_header_info',	
			'class' => 'investment-vc',		
			'category' => __('Investment', 'investment'),
			'description' => __('Display navbar logo & social icons', 'investment'),
	
			'params' => array(				
				array(
			      'type' => 'image_upload',
			      'heading' => __( 'Nav bar Logo', 'investment' ),
			      'param_name' => 'nav_logo',
			      'value' => INVESTMENT_ASSETS.'/images/logo.png',
			    ),	            
				// params group
	            array(
	                'type' => 'param_group',
	                'value' => '',
	                'save_always' => true,
	                'heading' => __( 'Social links', 'investment' ),
	                'param_name' => 'socaial_links',
	                'value' => urlencode( json_encode( array(
		                array(
		                	'title' => 'Facebook',
		                    'icon' => 'fa fa-facebook',
		                    'link' => '#',
		                ),
		                array(
		                	'title' => 'Twitter',
		                    'icon' => 'fa fa-twitter',
		                    'link' => '#',
		                ),
		                array(
		                	'title' => 'Linkedin',
		                    'icon' => 'fa fa-linkedin',
		                    'link' => '#',
		                ),
		                array(
		                	'title' => 'RSS',
		                    'icon' => 'fa fa-rss',
		                    'link' => '#',
		                ),
	                ) ) ),
	                'params' => array(
	                    
						array(
	                        'type' => 'textfield',
	                        'value' => '',
	                        'heading' => 'Title',
	                        'param_name' => 'title',	 
	                        'admin_label' => true,                       
	                    ),
	                    investment_vc_icon_set('fontawesome', 'icon', '', ''  ), 
	                    array(
	                        'type' => 'textfield',
	                        'heading' => 'Link',
	                        'param_name' => 'link',
	                        'admin_label' => true,
	                    ),
			                   
	                )
	            ),
				
			)
		) 
	);

	
	
}
class WPBakeryShortCode_Investment_onepage_header_info extends WPBakeryShortCode {
}

