<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_onepage_nav_shortcode_vc');
function investment_onepage_nav_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Onepage Nav menu', 'investment'),
			'base' => 'investment_onepage_nav',		
			'class' => 'investment-vc',	
			'category' => __('Investment', 'investment'),
			'description' => __('Display navbar logo & menu', 'investment'),
	
			'params' => array(	
				array(
			      'type' => 'checkbox',
			      'heading' => __( 'Navbar visible?', 'investment' ),
			      'param_name' => 'navbar_visible',
			      'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
			    ),			
			    array(
			      'type' => 'checkbox',
			      'heading' => __( 'Sticky navbar disable?', 'investment' ),
			      'param_name' => 'sticky_disable',
			      'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
			      'dependency' => array(
			        'element' => 'navbar_visible',
			        'value' => array('yes'),
			      ),
			    ),
				array(
			      'type' => 'image_upload',
			      'heading' => __( 'Nav bar Logo', 'investment' ),
			      'param_name' => 'nav_logo',
			      'value' => INVESTMENT_ASSETS.'/images/logo-white.png',
			      'description' => __('Display only on sticky navbar', 'investment'),
			    ),
			    array(
			      'type' => 'image_upload',
			      'heading' => __( 'header Logo', 'investment' ),
			      'param_name' => 'header_logo',
			      'value' => INVESTMENT_ASSETS.'/images/logo.png',
			      'dependency' => array(
				        'element' => 'navbar_visible',
				        'value' => array('yes'),
				      ),
			      'description' => __('Display only on header', 'investment'),
			    ),	            
				array(
		          'type' => 'dropdown',
		          'heading' => __('Select nav menu', 'investment'),
		          'param_name' => 'nav_menu',
		          'description' => __('You can create menu Appearance > Menu', 'investment'),
		          'value' => array_flip(investment_get_terms('nav_menu', 'slug')),		          
		        ), 
		        
				array(
			      'type' => 'param_group',
			      'save_always' => true,
			      'heading' => __( 'Nav buttons', 'investment' ),
			      'param_name' => 'buttons',
			      'value' => urlencode( json_encode( array(
			                    array(
			                      'button_text' => 'Get started',
			                       'button_url' => '#pricing',
			                    ),
			                  ) ) ),
			      'params' => array(
			            array(
							'type' => 'textfield',
							'heading' => __('Button title', 'investment'),
							'param_name' => 'button_text',
							'value' => 'Get started',
							'admin_label' => true
						),
						array(
							'type' => 'textfield',
							'heading' => __('Button url', 'investment'),
							'param_name' => 'button_url',
							'value' => '#pricing',
						),
			                 
			          ),

			    ),       
			
				
			)
		) 
	);

	
	
}
class WPBakeryShortCode_Investment_onepage_nav extends WPBakeryShortCode {
}

