<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_client_shortcode_vc');
function investment_client_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Our Clients', 'investment'),
			'base' => 'investment_our_clients',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => '',
			'params' => array(	
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'description' => '',
					'value' => 'Our clients know',
					'admin_label' => true,
				),	
				array(
					'type' => 'textfield',
					'heading' => __('Sub Title', 'investment'),
					'param_name' => 'subtitle',
					'description' => 'Use {} to highlight text',
					'value' => '{Investment Expert} is one of the largest and most experienced global private equity investors',
					'admin_label' => true,
				),	
				array(
					'type' => 'textarea_html',
					'heading' => __('Description', 'investment'),
					'param_name' => 'content',
					'description' => '',
					'value' => '<p>We seek to invest in well-positioned companies with operational and strategic improvement potential and partner with management teams to create value by driving revenue and earnings growth.</p>',
					'admin_label' => true,
				),	
				// params group
	            array(
	                'type' => 'param_group',
	                'save_always' => true,
	                'heading' => __( 'Clients logo', 'investment' ),
	                'param_name' => 'clients',
	                'value' => urlencode( json_encode( array(
						                array(
						                    'image' => INVESTMENT_ASSETS.'/images/client-1.png',
						                    'title' => 'Client 1',
						                    'image2' => INVESTMENT_ASSETS.'/images/client-4.png',				
						                    'title2' => 'Client 2'					                    
						                ),
						                array(
						                    'image' => INVESTMENT_ASSETS.'/images/client-2.png',		
						                    'title' => 'Client 3',
						                    'image2' => INVESTMENT_ASSETS.'/images/client-5.png',
						                    'title2' => 'Client 4'			                    
						                ),
						                array(
						                    'image' => INVESTMENT_ASSETS.'/images/client-3.png',
						                    'title' => 'Client 5',
						                    'image2' => INVESTMENT_ASSETS.'/images/client-6.png',
						                    'title2' => 'Client 6'					                    
						                ),
						                ) ) ),
	                'params' => array(  
	                	array(
							'type' => 'textfield',
							'heading' => __('Clients title', 'investment'),
							'param_name' => 'title',
							'description' => '',
							'value' => '',
							'admin_label' => true,
						),	                
						array(
			                'type' => 'image_upload',
			                'value' => '',
			                'heading' => 'Client logo',
			                'param_name' => 'image',
			            ),
			            array(
							'type' => 'textfield',
							'heading' => __('Clients title #2', 'investment'),
							'param_name' => 'title2',
							'description' => '',
							'value' => '',
							'admin_label' => true,
						),	                
						array(
			                'type' => 'image_upload',
			                'value' => '',
			                'heading' => 'Client logo #2',
			                'param_name' => 'image2',
			            ),
			            
	                   
	                )
	            ),
			)
		) 
	);
	
}

class WPBakeryShortCode_Investment_our_clients extends WPBakeryShortCode {
}
