<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_portfolio_templates_shortcode_vc');
function investment_portfolio_templates_shortcode_vc() {
	$category = investment_get_terms('portfolio_category', 'slug');
	$category = (!$category)? array() : $category;
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Portfolio', 'investment'),
			'base' => 'investment_portfolios',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Show Portfolio item with isotope, grid etc',
			'params' => array(
				array(
					'type' => 'dropdown',
					'heading' => __('Title display', 'investment'),
					'param_name' => 'title_display',
					'admin_label' => true,
					'value' =>  array(
							'Yes' => 'yes',	
							'No' => 'no'						
						),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'value' => 'Our Sector Knowledge',
					'description' => 'Use {} to highlight text',
					'admin_label' => true,
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Display type', 'investment'),
					'param_name' => 'template',
					'value' =>  array(
							'Isotope' => 'portfolio/isotope.php',							
						),
					'admin_label' => true
				),				
				array(
					'type' => 'number',
					'heading' => __('Posts per page', 'investment'),
					'param_name' => 'posts_per_page',
					'value' => -1,
					'min' => -1,
					'max' => '100',
					'step' => '1',
					'description' => 'Specify number of items that you want to show. Enter -1 to get all items',
					'admin_label' => true
				),
				array(
					'type' => 'textfield',
					'heading' => __('Category button title', 'investment'),
					'param_name' => 'read_more',
					'value' => 'know more',
					'admin_label' => true,
				),								
				array(
					'type' => 'perch_select',
					'multiple' => 'multiple',
					'heading' => __('Select category', 'investment'),
					'param_name' => 'tax_term',
					'value' =>  investment_get_terms('portfolio_category'),
					'group' => 'Posts Settings',
					'description' => 'Default all category are selected'
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Active category', 'investment'),
					'param_name' => 'active',
					'value' =>  array_merge(array('' => 'All'), $category),
					'group' => 'Posts Settings', 
					'dependency' => array(
						'element' => 'template',
						'value' => 'portfolio/isotope.php'
						)
				),
				array(
					'type' => 'textfield',
					'heading' => __('Post ID\'s', 'investment'),
					'param_name' => 'id',
					'value' => '',
					'description' => 'Enter comma separated ID\'s of the posts that you want to show',
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Taxonomy term operator', 'investment'),
					'param_name' => 'tax_operator',
					'description' => 'IN - posts that have any of selected categories terms<br/>NOT IN - posts that is does not have any of selected terms<br/>AND - posts that have all selected terms',
					'value' =>  array(
							'IN' => 'IN',
							'NOT IN' => 'NOT IN',
							'AND' => 'AND',
						),
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'textfield',
					'heading' => __('Authors', 'investment'),
					'param_name' => 'author',
					'description' => 'Enter here comma-separated list of author\'s IDs. Example: 1,7,18',					
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Order', 'investment'),
					'param_name' => 'tax_term',
					'description' => 'Posts order',
					'value' =>  array(
								'desc' => __( 'Descending', 'investment' ),
								'asc' => __( 'Ascending', 'investment' )
							),
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Order by', 'investment'),
					'param_name' => 'orderby',
					'description' => 'Order posts by',
					'selected' => 'date',
					'value' =>  array(
								'none' => __( 'None', 'investment' ),
								'id' => __( 'Post ID', 'investment' ),
								'author' => __( 'Post author', 'investment' ),
								'title' => __( 'Post title', 'investment' ),
								'name' => __( 'Post slug', 'investment' ),
								'date' => __( 'Date', 'investment' ), 
								'modified' => __( 'Last modified date', 'investment' ),
								'parent' => __( 'Post parent', 'investment' ),
								'rand' => __( 'Random', 'investment' ), 
								'comment_count' => __( 'Comments number', 'investment' ),
								'menu_order' => __( 'Menu order', 'investment' ), 'meta_value' => __( 'Meta key values', 'investment' ),
							),
					'group' => 'Posts Settings'
				),

				),
			)
		 
	);
	
}
