<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_blog_template_shortcode_vc');
function investment_blog_template_shortcode_vc() {
	$category = investment_get_terms('category', 'slug');
	$category = (!$category)? array() : $category;
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Blog Feeds', 'investment'),
			'base' => 'investment_posts',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Show blog posts',
			'params' => array(
				array(
					'type' => 'dropdown',
					'heading' => __('Title display', 'investment'),
					'param_name' => 'title_display',
					'admin_label' => true,
					'value' =>  array(
							'Yes' => 'yes',	
							'No' => 'no'						
						),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'value' => 'News',
					'description' => 'Use {} to highlight text',
					'admin_label' => true,
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				array(
					'type' => 'textarea',
					'heading' => __('Description', 'investment'),
					'param_name' => 'desc',
					'description' => '',
					'value' => 'Advent has one of the world’s largest and most experienced private equity teams, with more than 170 investment professionals across four continents.',
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button link text', 'investment'),
					'param_name' => 'button_link_text',
					'description' => 'Leave blank to avoid button',
					'value' => 'View all news',
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Image link type', 'investment'),
					'param_name' => 'image_link_type',
					'value' =>  array(
							'Popup' => 'popup',							
							'Post link' => 'link',							
						),
					'admin_label' => true
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Display type', 'investment'),
					'param_name' => 'template',
					'value' =>  array(
							'Default' => 'templates/default-loop.php',							
							'Isotope' => 'templates/isotope-loop.php',							
						),
					'admin_label' => true
				),
				array(
					'type' => 'number',
					'heading' => __('Posts per page', 'investment'),
					'param_name' => 'posts_per_page',
					'value' => '3',
					'min' => '-1',
					'max' => '100',
					'step' => '1',
					'description' => 'Specify number of posts that you want to show. Enter -1 to get all posts',
					'admin_label' => true
				),
				array(
					'type' => 'number',
					'heading' => __('Column', 'investment'),
					'param_name' => 'column',
					'value' => '3',
					'min' => '2',
					'max' => '4',
					'step' => '1',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Read more button title', 'investment'),
					'param_name' => 'read_more',
					'value' => 'Read more',
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Post ID\'s', 'investment'),
					'param_name' => 'id',
					'value' => '',
					'description' => 'Enter comma separated ID\'s of the posts that you want to show',
					'group' => 'Posts Settings'
				),				
				array(
					'type' => 'perch_select',
					'multiple' => 'multiple',
					'heading' => __('Select category', 'investment'),
					'param_name' => 'tax_term',
					'value' =>  investment_get_terms(),
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Active category', 'investment'),
					'param_name' => 'active',
					'value' =>  array_merge(array('' => 'All'), $category),
					'group' => 'Posts Settings', 
					'dependency' => array(
						'element' => 'template',
						'value' => 'templates/isotope-loop.php'
						),
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Taxonomy term operator', 'investment'),
					'param_name' => 'tax_operator',
					'description' => 'IN - posts that have any of selected categories terms<br/>NOT IN - posts that is does not have any of selected terms<br/>AND - posts that have all selected terms',
					'value' =>  array(
							'IN' => 'IN',
							'NOT IN' => 'NOT IN',
							'AND' => 'AND',
						),
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'textfield',
					'heading' => __('Authors', 'investment'),
					'param_name' => 'author',
					'description' => 'Enter here comma-separated list of author\'s IDs. Example: 1,7,18',					
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Order', 'investment'),
					'param_name' => 'tax_term',
					'description' => 'Posts order',
					'value' =>  array(
								'desc' => __( 'Descending', 'investment' ),
								'asc' => __( 'Ascending', 'investment' )
							),
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Order by', 'investment'),
					'param_name' => 'orderby',
					'description' => 'Order posts by',
					'selected' => 'date',
					'value' =>  array(
								'none' => __( 'None', 'investment' ),
								'id' => __( 'Post ID', 'investment' ),
								'author' => __( 'Post author', 'investment' ),
								'title' => __( 'Post title', 'investment' ),
								'name' => __( 'Post slug', 'investment' ),
								'date' => __( 'Date', 'investment' ), 
								'modified' => __( 'Last modified date', 'investment' ),
								'parent' => __( 'Post parent', 'investment' ),
								'rand' => __( 'Random', 'investment' ), 
								'comment_count' => __( 'Comments number', 'investment' ),
								'menu_order' => __( 'Menu order', 'investment' ), 'meta_value' => __( 'Meta key values', 'investment' ),
							),
					'group' => 'Posts Settings'
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Ignore sticky', 'investment'),
					'param_name' => 'ignore_sticky_posts',
					'description' => 'Select Yes to ignore posts that is sticked',
					'value' =>  array(
								'no' => __( 'No', 'investment' ),
								'yes' => __( 'Yes', 'investment' )
							),
					'group' => 'Posts Settings'
				),

				),
			)
		 
	);
	
}
