<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_pricing_table_shortcode_vc');
function investment_pricing_table_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Pricing table', 'investment'),
			'base' => 'investment_pricing_table',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'params' => array(	
				array(
					'type' => 'checkbox',
					'heading' => __( 'Featured?', 'investment' ),
					'param_name' => 'featured',
					'value' => array( __( 'Yes', 'investment' ) => 'yes' )					
				),							
            	array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'value' => 'Standard plan',
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Price unit', 'investment'),
					'param_name' => 'unit',
					'value' => '$',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Price', 'investment'),
					'param_name' => 'price',
					'value' => '{48}/mo',
					'admin_label' => true,
					'description' => 'use {} for highlight text',
				),      
				array(
					'type' => 'textfield',
					'heading' => __('Button link text', 'investment'),
					'param_name' => 'link_title',
					'description' => 'Leave blank to avoid button',
					'value' => 'Get started now',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button url', 'investment'),
					'param_name' => 'link',
					'value' => '#',
				),
				array(
					'type' => 'textarea_html',
					'heading' => __('Description', 'investment'),
					'param_name' => 'content',
					'description' => '',
					'value' => '<div style="text-align: center"><p>10 ready home page</p><p>5 different header style</p><p>Unlimited data transfer</p><p>30 days moneyback guarantee</p><p>Enhanced security</p></div>',
					'admin_label' => true
				), 
				
			)
		) 
	);
	
}
class WPBakeryShortCode_Investment_pricing_table extends WPBakeryShortCode {
}
