<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_services_shortcode_vc');
function investment_services_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Service', 'investment'),
			'base' => 'investment_services',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Square dark box with icon, title and link',
			'params' => array(	
				array(
					'type' => 'perch_select',
					'heading' => __('Hover Style', 'investment'),
					'param_name' => 'style',
					'value' =>  array(
								'style1' => __( 'Style1', 'investment' ),
								'style2' => __( 'Style2', 'investment' ),
							),
				),
				investment_vc_icontype_dropdown('type'),
            	investment_vc_icon_set('perch', 'icon_perch', 'perch perch-value', 'type'  ),	
            	investment_vc_icon_set('pixden', 'icon_pixden', '', 'type'  ),                
            	investment_vc_icon_set('linecons', 'icon_linecons', '', 'type'  ),         
            	investment_vc_icon_set('entypo', 'icon_entypo', '', 'type'  ), 
            	investment_vc_icon_set('typicons', 'icon_typicons', '', 'type'  ),       
            	investment_vc_icon_set('openiconic', 'icon_openiconic', '', 'type'  ),       
            	investment_vc_icon_set('fontawesome', 'icon_fontawesome', '', 'type'  ), 
            	array(
					'type' => 'textarea',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'value' => 'Value Orientation',
					'admin_label' => true,
				),      
				array(
					'type' => 'textfield',
					'heading' => __('Button link text', 'investment'),
					'param_name' => 'link_title',
					'description' => 'Leave blank to avoid button',
					'value' => 'Know more',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button url', 'investment'),
					'param_name' => 'link',
					'value' => '#',
				), 
				array(
	                'type' => 'checkbox',
	                'heading' => __( 'Add link in service title', 'investment' ),
	                'param_name' => 'enable_title_link',
	                'value' => array( __( 'Yes', 'investment' ) => 'yes' ),        
	            ),
	            array(
	                'type' => 'checkbox',
	                'heading' => __( 'Hide button', 'investment' ),
	                'param_name' => 'hide_button',
	                'value' => array( __( 'Yes', 'investment' ) => 'yes' ),        
	            ),
				
			)
		) 
	);
	
}
class WPBakeryShortCode_Investment_services extends WPBakeryShortCode {
}
