<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_skillbar_shortcode_vc');
function investment_skillbar_shortcode_vc() {
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Skillbar', 'investment'),
			'base' => 'investment_skillbar',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Title & progress bar in percent',			
			'params' => array(				
            	array(
					'type' => 'param_group',
					'save_always' => true,
					'heading' => __( 'Values', 'investment' ),
					'param_name' => 'values',
					'description' => __( 'Enter values for graph - value, title and color.', 'investment' ),
					'value' => urlencode( json_encode( array(
						array(
							'label' => __( 'Development', 'investment' ),
							'value' => '90',
							'customcolor' => '#ffc000'
						),
						array(
							'label' => __( 'Design', 'investment' ),
							'value' => '80',
							'customcolor' => '#fc7f0c'
						),
						array(
							'label' => __( 'Photography', 'investment' ),
							'value' => '85',
							'customcolor' => ot_get_option( 'primary_color', '#f3525a' )
						),
						array(
							'label' => __( 'Marketing', 'investment' ),
							'value' => '70',
							'customcolor' => ot_get_option( 'secondary_color', '#20304f' )
						),
					) ) ),
					'params' => array(
						array(
							'type' => 'textfield',
							'heading' => __( 'Label', 'investment' ),
							'param_name' => 'label',
							'description' => __( 'Enter text used as title of bar.', 'investment' ),
							'admin_label' => true,
						),
						array(
							'type' => 'textfield',
							'heading' => __( 'Value', 'investment' ),
							'param_name' => 'value',
							'description' => __( 'Enter value of bar.', 'investment' ),
							'admin_label' => true,
						),
						array(
							'type' => 'colorpicker',
							'heading' => __( 'Custom color', 'investment' ),
							'param_name' => 'customcolor',
							'description' => __( 'Select custom single bar background color.', 'investment' ),
							
						),
					),
				),
				
			),	

	));
	
}

class WPBakeryShortCode_Investment_skillbar extends WPBakeryShortCode {
}