<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_tabs_shortcode_vc');
function investment_tabs_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Tabs', 'investment'),
			'base' => 'investment_tabs',
			'class' => 'investment-vc wpb_vc_tta_tabs',
			'category' => __('Investment', 'investment'),
			'is_container' => true,
			'show_settings_on_create' => false,
			'as_parent' => array(
				'only' => 'vc_tta_section',
			),
			'category' => __('Investment', 'investment'),
			'description' => 'Toggle area can be used for Faqs, etc',
			'params' => array(					
				),
				'js_view' => 'VcBackendTtaTabsView',
	'custom_markup' => '
<div class="vc_tta-container" data-vc-action="collapse">
	<div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
		<div class="vc_tta-tabs-container">'
	                   . '<ul class="vc_tta-tabs-list">'
	                   . '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
	                   . '</ul>
		</div>
		<div class="vc_tta-panels vc_clearfix {{container-class}}">
		  {{ content }}
		</div>
	</div>
</div>',
	'default_content' => '
[vc_tta_section title="' . sprintf( '%s %d', __( 'Tab', 'investment' ), 1 ) . '"][/vc_tta_section]
[vc_tta_section title="' . sprintf( '%s %d', __( 'Tab', 'investment' ), 2 ) . '"][/vc_tta_section]
	',
	'admin_enqueue_js' => array(
		vc_asset_url( 'lib/vc_tabs/vc-tabs.min.js' ),
	),
		) 
	);

	
	
}
