<?php 
/**
 * The VC Functions
 */
function investment_team_template_shortcode_vc() {
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Team template', 'investment'),
			'base' => 'investment_teams',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Show Team members',
			'params' => array(
				array(
					'type' => 'dropdown',
					'heading' => __('Title display', 'investment'),
					'param_name' => 'title_display',
					'admin_label' => true,
					'value' =>  array(
							'Yes' => 'yes',	
							'No' => 'no'						
						),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'value' => '{Experienced} Team',
					'description' => 'Use {} to highlight text',
					'admin_label' => true,
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				array(
					'type' => 'textarea',
					'heading' => __('Description', 'investment'),
					'param_name' => 'desc',
					'description' => '',
					'value' => 'Advent has one of the world’s largest and most experienced private equity teams, with more than 170 investment professionals across four continents.',
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Link type', 'investment'),
					'param_name' => 'link_type',
					'admin_label' => true,
					'value' =>  array(
							'Archive page link' => 'archive',	
							'Custom page link' => 'custom_link'						
						),
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				array(
					'type' => 'textfield',
					'heading' => __('Button link text', 'investment'),
					'param_name' => 'button_link_text',
					'description' => 'Leave blank to avoid button',
					'value' => 'Meet our team',
					'dependency' => array(
						'element' => 'title_display',
						'value' => 'yes'
						)
				),
				
				array(
					'type' => 'textfield',
					'heading' => __('Button link', 'investment'),
					'param_name' => 'button_link',
					'value' => '#',
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Display type', 'investment'),
					'param_name' => 'template',
					'value' =>  array(
							'Default' => 'team/default-loop.php',							
						),
					'admin_label' => true
				),
				array(
					'type' => 'number',
					'heading' => __('Posts per page', 'investment'),
					'param_name' => 'posts_per_page',
					'value' => '3',
					'min' => '-1',
					'max' => '100',
					'step' => '1',
					'description' => 'Specify number of posts that you want to show. Enter -1 to get all posts',
					'admin_label' => true
				),
				array(
					'type' => 'number',
					'heading' => __('Column', 'investment'),
					'param_name' => 'column',
					'value' => '3',
					'min' => '2',
					'max' => '4',
					'step' => '1',
				),
				array(
	                'type' => 'perch_select',
	                'value' => array('all' => 'All', 'specific' => 'Specific team'),
	                'heading' => 'Team display from',
	                'param_name' => 'display',
	            ),
	            // params group
	            array(
	                'type' => 'param_group',
	                'value' => '',
	                'heading' => __( 'Teams', 'investment' ),
	                'param_name' => 'teams',
	                'value' => '',
	                'params' => array(
	                    array(
	                        'type' => 'perch_select',
	                        'value' => investment_get_posts_dropdown(array('post_type' => 'team', 'posts_per_page' => -1)),
	                        'heading' => 'Team',
	                        'param_name' => 'team',
	                        'admin_label' => true,
	                    ),
	                   
	                ),
                'dependency' => array(
                    'element' => 'display',
                    'value' => 'specific'
                )
            ),
				array(
					'type' => 'perch_select',
					'heading' => __('Order', 'investment'),
					'param_name' => 'tax_term',
					'description' => 'Posts order',
					'value' =>  array(
								'desc' => __( 'Descending', 'investment' ),
								'asc' => __( 'Ascending', 'investment' )
							),
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Order by', 'investment'),
					'param_name' => 'orderby',
					'description' => 'Order posts by',
					'selected' => 'date',
					'value' =>  array(
								'none' => __( 'None', 'investment' ),
								'id' => __( 'Post ID', 'investment' ),
								'author' => __( 'Post author', 'investment' ),
								'title' => __( 'Post title', 'investment' ),
								'name' => __( 'Post slug', 'investment' ),
								'date' => __( 'Date', 'investment' ), 
								'modified' => __( 'Last modified date', 'investment' ),
								'parent' => __( 'Post parent', 'investment' ),
								'rand' => __( 'Random', 'investment' ), 
								'comment_count' => __( 'Comments number', 'investment' ),
								'menu_order' => __( 'Menu order', 'investment' ), 'meta_value' => __( 'Meta key values', 'investment' ),
							),
				),

				),
			)
		 
	);
	
}
add_action( 'vc_before_init', 'investment_team_template_shortcode_vc');

class WPBakeryShortCode_Investment_teams extends WPBakeryShortCode {
}