<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_testimonial_shortcode_vc');
function investment_testimonial_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Testimonial', 'investment'),
			'base' => 'investment_testimonial',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Display single testimonial or multiple as carousel',
			'params' => array(
				array(
					'type' => 'perch_select',
					'heading' => __('Style', 'investment'),
					'param_name' => 'style',
					'value' =>  array(
								'style1' => __( 'Style1(Circle image on left side)', 'investment' ),
								'style2' => __( 'Style2(Image placed in bootom of testimonial)', 'investment' ),
							),
				),
				array(
			        'type' => 'dropdown',
			        'heading' => __( 'Testimonial Background', 'investment' ),
			        'param_name' => 'bg_class',
			        'value' => array(
			                    'Default Background color'  => 'tra-bg',                    
			                    'Primary Background color'  => 'primary-bg',
			                    'Secondary Background color'  => 'secondary-bg-dark',
			                    'Secondary Light Background color'  => 'secondary-light-bg',
			                    'Secondary Dark Background color'  => 'secondary-dark-bg',
			                    'Gray Background color'  => 'bg_gray'
			                  ),
			        'std' => 'tra-bg',
			        'description' => '',        
			    ),
				// params group
	            array(
	                'type' => 'param_group',
	                'save_always' => true,
	                'description' => 'Multiple testimonial show as a carousel',
	                'heading' => __( 'Testimonial', 'investment' ),
	                'param_name' => 'testimonials',
	                'value' => urlencode( json_encode( array(
						                array(
						                    'image' => INVESTMENT_ASSETS.'/images/photo-man.png',
						                    'title' => 'Alexa Von Tobel',				                    
						                    'subtitle' => 'CEO Finance Consult Manager',                   
						                    'desc' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad',	
						                    'signature' => INVESTMENT_ASSETS.'/images/painting-1.png',		                    
						                ),
						                ) ) ),
	                'params' => array(  
	                	array(
			                'type' => 'image_upload',
			                'value' => '',
			                'heading' => 'Testimonial image',
			                'param_name' => 'image',
			            ),
	                	array(
							'type' => 'textfield',
							'heading' => __('Title', 'investment'),
							'param_name' => 'title',
							'description' => '',
							'value' => 'Jhone doe',
							'admin_label' => true,
						),
						array(
							'type' => 'textfield',
							'heading' => __('Sub-title', 'investment'),
							'param_name' => 'subtitle',
							'description' => '',
							'value' => 'Marketing Consult Manager',
							'admin_label' => true,
						),
						array(
			                'type' => 'image_upload',
			                'value' => '',
			                'heading' => 'Signature',
			                'param_name' => 'signature',
			                'description' => 'This field only appears for testimonial Style1',
			            ),
			            array(
							'type' => 'textarea',
							'heading' => __('Testimonial description', 'investment'),
							'param_name' => 'desc',
							'description' => 'CEO Finance Consult Manager',
							'value' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad',
						),	
			            
	                   
	                )
	            ),
			)
		) 
	);
	
}
class WPBakeryShortCode_Investment_testimonial extends WPBakeryShortCode {
}