<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_timeline_shortcode_vc');
function investment_timeline_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Timeline', 'investment'),
			'base' => 'investment_timeline',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Used for company history',
			'params' => array(					
				// params group
	            array(
	                'type' => 'param_group',
	                'save_always' => true,
	                'heading' => __( 'Timeline history', 'investment' ),
	                'param_name' => 'history',
	                'value' => urlencode( json_encode( array(
						                array(
						                	'year' => '1941',						                    
						                    'title' => 'Established',
						                    'description' => 'It became the State Association of Investment Companies in 1941. In 1940,Company members included 68 mutual funds and 43 closed-end funds,and assets for the fund industry totaled $2.1 billion.'					                    
						                ),
						                array(
						                	'year' => '1999',						                    
						                    'title' => 'Became The Investment Expert',
						                    'description' => 'SAIC changed its name to the Investment Expert in 1999,the year that underwriters and advisers of mutual funds became eligible for membership.IE objectives are essential organizing priciples for the many and varied activites in which the comapny participates.'					                    
						                ),
						                array(
						                	'year' => '2005',						                    
						                    'title' => 'IE Relocated To Washington,DC',
						                    'description' => 'It became the State Association of Investment Companies in 1941. In 1940,Company members included 68 mutual funds and 43 closed-end funds,and assets for the fund industry totaled $2.1 billion.'					                    
						                ),
						                array(
						                	'year' => '2016',						                    
						                    'title' => 'Today in 2016',
						                    'description' => 'Today,in 2016,IE celebrates the 75th anniversary of its founding and of the key legislation that gave rise to the modern fund industry.IE serves as a spokesman for funds and their share holders before policymakers,opinion leaders and the global media.'					                    
						                ),
						                ) ) ),
	                'params' => array(  
	                	array(
							'type' => 'textfield',
							'heading' => __('Year', 'investment'),
							'param_name' => 'year',
							'description' => '',
							'value' => '',
							'admin_label' => true,
						),	 
	                	array(
							'type' => 'textfield',
							'heading' => __('Title', 'investment'),
							'param_name' => 'title',
							'description' => '',
							'value' => '',
							'admin_label' => true,
						),	                
						array(
			                'type' => 'textarea',
			                'value' => '',
			                'heading' => 'Description',
			                'param_name' => 'description',
			            ),
			            
	                   
	                )
	            ),
			)
		) 
	);
	
}

class WPBakeryShortCode_Investment_timeline extends WPBakeryShortCode {
}

