<?php 
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_title_shortcode_vc');
function investment_title_shortcode_vc() {
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Title', 'investment'),
			'base' => 'investment_title',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => 'Show heading with different style',
			
			'params' => array(
				array(
					'type' => 'perch_select',
					'heading' => __('Alignment', 'investment'),
					'param_name' => 'align',
					'value' =>  array(
								'left' => __( 'Default', 'investment' ),
								'center' => __( 'Center', 'investment' ),
							),
					'save_always' => true,
				),
				array(
					'type' => 'perch_select',
					'heading' => __('Heading tag', 'investment'),
					'param_name' => 'tag',
					'save_always' => true,
					'value' =>  array(
								'h1' => __( 'H1', 'investment' ),
								'h2' => __( 'H2', 'investment' ),
								'h3' => __( 'H3', 'investment' ),
								'h4' => __( 'H4', 'investment' ),
								'h5' => __( 'H5', 'investment' ),
								'h6' => __( 'H6', 'investment' ),
							),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Heading Title', 'investment'),
					'param_name' => 'title',
					'description' => 'use {} for highlight text',
					'value' => '{Investment Expert} title',
					'admin_label' => true
				),
				array(
					'type' => 'checkbox',
					'heading' => __( 'Add underline?', 'investment' ),
					'param_name' => 'add_underline',
					'description' => __( 'Display underline after title', 'investment' ),
					'value' => array( __( 'Yes', 'investment' ) => 'yes' )					
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Underline style', 'investment' ),
					'param_name' => 'style',
					'value' => array(
						__( 'Thin', 'investment' ) => 'underline-primary',
						__( 'Bold', 'investment' ) => 'underline_small',
					),
					'std' => 'underline-primary',
					'dependency' => array(
						'element' => 'add_underline',
						'value' => array( 'yes')
					),
				),
				array(
					'type' => 'textarea_html',
					'heading' => __('Description', 'investment'),
					'param_name' => 'content',
					'description' => '',
					'value' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad</p>',
					'admin_label' => true
				),
			),	

	));
	
}

class WPBakeryShortCode_Investment_title extends WPBakeryShortCode {
}