<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
add_action('vc_after_init', 'investment_vc_button_param');

function investment_vc_button_param(){
	$newParamData = array(
			array(
				'type' => 'dropdown',
				'heading' => __( 'Style', 'investment' ),
				'description' => __( 'Select button display style.', 'investment' ),
				'param_name' => 'style',
				// partly compatible with btn2, need to be converted shape+style from btn2 and btn1
				'value' => array(
					__( 'Investment', 'investment' ) => 'investment',
					__( 'Modern', 'investment' ) => 'modern',
					__( 'Classic', 'investment' ) => 'classic',
					__( 'Flat', 'investment' ) => 'flat',
					__( 'Outline', 'investment' ) => 'outline',
					__( '3d', 'investment' ) => '3d',
					__( 'Custom', 'investment' ) => 'custom',
					__( 'Outline custom', 'investment' ) => 'outline-custom',
					__( 'Gradient', 'investment' ) => 'gradient',
					__( 'Gradient Custom', 'investment' ) => 'gradient-custom',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Shape', 'investment' ),
				'description' => __( 'Select button shape.', 'investment' ),
				'param_name' => 'shape',
				// need to be converted
				'value' => array(
					__( 'Square', 'investment' ) => 'square',
					__( 'Rounded', 'investment' ) => 'rounded',
					__( 'Round', 'investment' ) => 'round',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Color', 'investment' ),
				'param_name' => 'color',
				'description' => __( 'Select button color.', 'investment' ),
				// compatible with btn2, need to be converted from btn1
				'param_holder_class' => 'vc_colored-dropdown vc_btn3-colored-dropdown',
				'value' => array(
						// Btn1 Colors
						__( 'Investment Primary', 'investment' ) => 'btn-primary',
						__( 'Investment Primary outline', 'investment' ) => 'btn-primary-outline',
						__( 'Investment Secondary', 'investment' ) => 'btn-secondary',
						__( 'Classic Grey', 'investment' ) => 'default',
						__( 'Classic Blue', 'investment' ) => 'primary',
						__( 'Classic Turquoise', 'investment' ) => 'info',
						__( 'Classic Green', 'investment' ) => 'success',
						__( 'Classic Orange', 'investment' ) => 'warning',
						__( 'Classic Red', 'investment' ) => 'danger',
						__( 'Classic Black', 'investment' ) => 'inverse',
						// + Btn2 Colors (default color set)
					) + vc_get_shared( 'colors-dashed' ),
				'std' => 'btn-primary',
				// must have default color grey
				'dependency' => array(
					'element' => 'style',
					'value_not_equal_to' => array(
						'custom',
						'outline-custom',
						'gradient',
						'gradient-custom',
					),
				),
			),
		); 

	foreach ($newParamData as $key => $value) {
		vc_update_shortcode_param( 'vc_btn', $value );
	}

	
}
