<?php
add_action('vc_after_init', function() {

    $paramsArr = [

        [
            'type' => 'dropdown',
            'heading' => __( 'Row stretch', 'investment' ),
            'param_name' => 'full_width',
            'group' => 'Investment Settings',
            'value' => array(
                __( 'Default', 'investment' ) => '',
                __( 'Stretch row', 'investment' ) => 'stretch_row',
                __( 'Stretch row and content', 'investment' ) => 'stretch_row_content',
                __( 'Stretch row and content (no paddings)', 'investment' ) => 'stretch_row_content_no_spaces',
            ),
            'description' => __( 'Select stretching options for row and content (Note: stretched may not work properly if parent container has "overflow: hidden" CSS property).', 'investment' ),
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Row padding class name', 'investment' ),
            'param_name' => 'padding_class',
            'group' => 'Investment Settings',
            'value' => array(
                        'Row padding default'  => '',
                        'Row padding normal'  => 'section-padding-normal',
                        'Row padding small'  => 'section-padding-small',
                        'Row no padding'  => 'section-no-padding',
                        'Row top padding only'  => 'section-top-padding',
                        'Row Bottom padding only'  => 'section-bottom-padding',
                    ),
            'description' => '',
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Section Background', 'investment' ),
            'param_name' => 'bg_class',
            'group' => 'Investment Settings',
            'value' => array(
                        'Default Background color'  => 'default-bg',                    
                        'Primary Background color'  => 'primary-bg',
                        'Secondary Background color'  => 'secondary-bg-dark',
                        'Secondary Light Background color'  => 'secondary-light-bg',
                        'Secondary Dark Background color'  => 'secondary-dark-bg',
                        'Gray Background color'  => 'bg_gray',
                    ),
            'description' => '',  
            'edit_field_class' => 'vc_col-sm-9', 
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Use overlay?', 'investment' ),
            'param_name' => 'overlay_bg',
            'description' => __( 'If checked, overlay will be applied on section background.', 'investment' ),
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Overlay type', 'investment' ),
            'param_name' => 'overlay_class',
            'group' => 'Investment Settings',
            'value' => array(
                        'Dark overlay'  => 'dark-overlay',                    
                        'Primary overlay'  => 'primary-overlay',
                        'Secondary overlay'  => 'secondary-overlay',
                        'light overlay'  => 'light-overlay',
                    ),
            'description' => '',
            'dependency' => array(
                'element' => 'overlay_bg',
                'not_empty' => true,
            ),
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Use video background?', 'investment' ),
            'param_name' => 'video_bg',
            'description' => __( 'If checked, video will be used as section background.', 'investment' ),
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
        ],

        [
            'type' => 'textfield',
            'heading' => __( 'YouTube link', 'investment' ),
            'param_name' => 'video_bg_url',
            'value' => 'https://www.youtube.com/watch?v=lMJXxhRFO1k',
            'description' => __( 'Add YouTube link.', 'investment' ),
            'group' => 'Investment Settings',
            'dependency' => array(
                'element' => 'video_bg',
                'not_empty' => true,
            ),
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Parallax', 'investment' ),
            'param_name' => 'video_bg_parallax',
            'group' => 'Investment Settings',
            'value' => array(
                __( 'None', 'investment' ) => '',
                __( 'Simple', 'investment' ) => 'content-moving',
                __( 'With fade', 'investment' ) => 'content-moving-fade',
            ),
            'description' => __( 'Add parallax type background for section.', 'investment' ),
            'dependency' => array(
                'element' => 'video_bg',
                'not_empty' => true,
            ),
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Parallax', 'investment' ),
            'param_name' => 'parallax',
            'value' => array(
                __( 'None', 'investment' ) => '',
                __( 'Simple', 'investment' ) => 'content-moving',
                __( 'With fade', 'investment' ) => 'content-moving-fade',
            ),
            'description' => __( 'Add parallax type background for section (Note: If no image is specified, parallax will use background image from Design Options).', 'investment' ),
            'group' => 'Investment Settings',
            'dependency' => array(
                'element' => 'video_bg',
                'is_empty' => true,
            ),
        ],

        [
            'type' => 'image_upload',
            'heading' => __( 'Image', 'investment' ),
            'param_name' => 'parallax_image',
            'value' => INVESTMENT_ASSETS.'/images/home-banner-bg.jpg',
            'description' => __( 'Select image from media library.', 'investment' ),
            'group' => 'Investment Settings',
            'dependency' => array(
                'element' => 'parallax',
                'not_empty' => true,
            ),
        ],

        [
            'type' => 'textfield',
            'heading' => __( 'Parallax speed', 'investment' ),
            'param_name' => 'parallax_speed_video',
            'value' => '1.5',
            'group' => 'Investment Settings',
            'description' => __( 'Enter parallax speed ratio (Note: Default value is 1.5, min value is 1)', 'investment' ),
            'dependency' => array(
                'element' => 'video_bg_parallax',
                'not_empty' => true,
            ),
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Top Arrow?', 'investment' ),
            'param_name' => 'top_arrow',
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
            'edit_field_class' => 'vc_col-sm-6',
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Bottom Arrow?', 'investment' ),
            'param_name' => 'bottom_arrow',
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
            'edit_field_class' => 'vc_col-sm-6',
        ]

    ];

    foreach ($paramsArr as $key => $param) {
        vc_update_shortcode_param( 'vc_row', $param );
    }
   
});