<?php
add_action('vc_after_init', function() {

    $paramsArr = [

        [
            'group' => 'Investment Settings',
            'type' => 'dropdown',
            'heading' => __( 'Section stretch', 'investment' ),
            'param_name' => 'full_width',
            'value' => array(
                __( 'Default', 'investment' ) => 'container',
                __( 'Stretch section', 'investment' ) => 'container-wide',       
            ),
            'weight' => '204',
            'edit_field_class' => 'vc_col-sm-6',
            'description' => __( 'Select stretching options for section and content (Note: stretched may not work properly if parent container has "overflow: hidden" CSS property).', 'investment' ),
        ],

        [
            'group' => 'Investment Settings',
            'type' => 'el_id',
            'heading' => __( 'Section ID', 'investment' ),
            'param_name' => 'el_id',
            'description' => sprintf( __( 'Enter section ID (Note: make sure it is unique and valid according to <a href="%s" target="_blank">w3c specification</a>).', 'investment' ), 'http://www.w3schools.com/tags/att_global_id.asp' ),
            'weight' => '204',
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Use section as header', 'investment' ),
            'param_name' => 'header',
            'description' => __( 'If checked, section will be used as header.', 'investment' ),
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
            'weight' => '204',
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Use transparent header', 'investment' ),
            'param_name' => 'transparent_header',
            'description' => __( 'If checked, Menu background will be force to transparent.', 'investment' ),
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
            'dependency' => array(
                'element' => 'header',
                'value' => array('yes'),
                ),
            'weight' => '204',
            'edit_field_class' => 'vc_col-sm-6',
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Use section as footer', 'investment' ),
            'param_name' => 'footer',
            'description' => __( 'If checked, section will be used as footer.', 'investment' ),
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
            'weight' => '204',
        ],

        [
            'group' => 'Investment Settings',
            'type' => 'dropdown',
            'heading' => __( 'Background video type', 'investment' ),
            'param_name' => 'video_bg',
            'value' => array(
                __( 'None', 'investment' ) => '',
                __( 'Youtube video', 'investment' ) => 'yes',
                __( 'HTML5 video', 'investment' ) => 'html5',       
            ),
            'weight' => '204',
        ],

        [
            'type' => 'textfield',
            'heading' => __( 'YouTube link', 'investment' ),
            'param_name' => 'video_bg_url',
            'value' => 'https://www.youtube.com/watch?v=lMJXxhRFO1k',
            'description' => __( 'Add YouTube link.', 'investment' ),
            'group' => 'Investment Settings',
            'dependency' => array(
                'element' => 'video_bg',
                'value' => 'yes',
            ),
            'weight' => '204',
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Parallax', 'investment' ),
            'param_name' => 'video_bg_parallax',
            'group' => 'Investment Settings',
            'value' => array(
                __( 'None', 'investment' ) => '',
                __( 'Simple', 'investment' ) => 'content-moving',
                __( 'With fade', 'investment' ) => 'content-moving-fade',
            ),
            'description' => __( 'Add parallax type background for section.', 'investment' ),
            'dependency' => array(
                'element' => 'video_bg',
                'value' => 'yes',
            ),
            'weight' => '204',
        ],

        [
            'type' => 'textfield',
            'heading' => __( 'Parallax speed', 'investment' ),
            'param_name' => 'parallax_speed_video',
            'value' => '1.5',
            'group' => 'Investment Settings',
            'description' => __( 'Enter parallax speed ratio (Note: Default value is 1.5, min value is 1)', 'investment' ),
            'dependency' => array(
                'element' => 'video_bg_parallax',
                'not_empty' => true,
            ),
            'weight' => '204',
        ],

        [
            'type' => 'image_upload',
            'heading' => __( 'Poster Image', 'investment' ),
            'param_name' => 'html5_video_image',
            'description' => '',
            'group' => 'Investment Settings',
            'value' => get_stylesheet_directory_uri() . '/video/video.jpg',
            'dependency' => array( 'element' => 'video_bg', 'value' => 'html5' ),
            'weight' => '204',
        ],

        [
            'type' => 'image_upload',
            'heading' => __( '.mp4 format video', 'investment' ),
            'param_name' => 'mp4',
            'description' => '',
            'group' => 'Investment Settings',
            'value' => 'http://themeperch.net/videos/1/video.mp4',
            'dependency' => array( 'element' => 'video_bg', 'value' => 'html5' ), 
            'weight' => '204', 
        ],

        [
            'type' => 'image_upload',
            'heading' => __( '.webm format video', 'investment' ),
            'param_name' => 'webm',
            'description' => '',
            'group' => 'Investment Settings',
            'value' => 'http://themeperch.net/videos/1/video.webm',
            'dependency' => array( 'element' => 'video_bg', 'value' => 'html5' ),  
            'weight' => '204',
        ],

        [
            'type' => 'image_upload',
            'group' => 'Investment Settings',
            'heading' => __( '.ogv format video', 'investment' ),
            'param_name' => 'ogv',
            'description' => '',
            'value' => 'http://themeperch.net/videos/1/video.ogv',
            'dependency' => array( 'element' => 'video_bg', 'value' => 'html5' ), 
            'weight' => '204',
        ],


        [
            'type' => 'dropdown',
            'heading' => __( 'Section class name', 'investment' ),
            'param_name' => 'padding_class',
            'group' => 'Investment Settings',
            'value' => array(
                        'Section padding normal'  => 'section-padding-normal',
                        'Section padding large'  => 'section-padding-large',
                        'Section padding small'  => 'section-padding-small',
                        'Section no padding'  => 'section-no-padding',
                        'Section top padding only'  => 'section-top-padding',
                        'Section Bottom padding only'  => 'section-bottom-padding',
                    ),
            'description' => '',
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Section Background', 'investment' ),
            'param_name' => 'bg_class',
            'group' => 'Investment Settings',
            'value' => array(
                        'Default Background color'  => 'default-bg',                    
                        'Primary Background color'  => 'primary-bg',
                        'Secondary Background color'  => 'secondary-bg-dark',
                        'Secondary Light Background color'  => 'secondary-light-bg',
                        'Secondary Dark Background color'  => 'secondary-dark-bg',
                        'Gray Background color'  => 'bg_gray',
                    ),
            'description' => '',  
            'edit_field_class' => 'vc_col-sm-9', 
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Use overlay?', 'investment' ),
            'param_name' => 'overlay_bg',
            'description' => __( 'If checked, overlay will be applied on section background.', 'investment' ),
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Overlay type', 'investment' ),
            'param_name' => 'overlay_class',
            'group' => 'Investment Settings',
            'value' => array(
                        'Dark overlay'  => 'dark-overlay',                    
                        'Primary overlay'  => 'primary-overlay',
                        'Secondary overlay'  => 'secondary-overlay',
                        'light overlay'  => 'light-overlay',
                    ),
            'description' => '',
            'dependency' => array(
                'element' => 'overlay_bg',
                'value' => array('yes'),
            ),
        ],

        [
            'type' => 'dropdown',
            'heading' => __( 'Parallax', 'investment' ),
            'param_name' => 'parallax',
            'value' => array(
                __( 'None', 'investment' ) => '',
                __( 'Simple', 'investment' ) => 'content-moving',
                __( 'With fade', 'investment' ) => 'content-moving-fade',
            ),
            'description' => __( 'Add parallax type background for section (Note: If no image is specified, parallax will use background image from Design Options).', 'investment' ),
            'group' => 'Investment Settings',
            'dependency' => array(
                'element' => 'video_bg',
                'is_empty' => true,
            ),
        ],

        [
            'type' => 'image_upload',
            'heading' => __( 'Image', 'investment' ),
            'param_name' => 'parallax_image',
            'value' => '',
            'description' => __( 'Select image from media library.', 'investment' ),
            'group' => 'Investment Settings',
            'dependency' => array(
                'element' => 'parallax',
                'not_empty' => true,
            ),
        ],

        [
            'type' => 'textfield',
            'heading' => __( 'Parallax speed', 'investment' ),
            'param_name' => 'parallax_speed_bg',
            'value' => '1',
            'description' => __( 'Enter parallax speed ratio (Note: Default value is 1.5, min value is 1)', 'investment' ),
            'dependency' => array(
              'element' => 'parallax',
              'not_empty' => true,
            ),
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Top Arrow?', 'investment' ),
            'param_name' => 'top_arrow',
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
            'edit_field_class' => 'vc_col-sm-6',
        ],

        [
            'type' => 'checkbox',
            'group' => 'Investment Settings',
            'heading' => __( 'Bottom Arrow?', 'investment' ),
            'param_name' => 'bottom_arrow',
            'value' => array( __( 'Yes', 'investment' ) => 'yes' ),
            'edit_field_class' => 'vc_col-sm-6',
        ]

    ];

    foreach ($paramsArr as $key => $param) {
       vc_update_shortcode_param( 'vc_section', $param );
    }
   
});