<?php
/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_working_hours_shortcode_vc');
function investment_working_hours_shortcode_vc() {	
	
	vc_map( 
		array(
			'icon' => 'investment-icon',
			'name' => __('Working hours', 'investment'),
			'base' => 'investment_working_hours',
			'class' => 'investment-vc',
			'category' => __('Investment', 'investment'),
			'description' => '',
			'params' => array(	
				array(
					'type' => 'textfield',
					'heading' => __('Title', 'investment'),
					'param_name' => 'title',
					'description' => '',
					'value' => 'Working Hours',
					'admin_label' => true,
				),	
				array(
					'type' => 'textfield',
					'heading' => __('Sub Title', 'investment'),
					'param_name' => 'subtitle',
					'description' => 'Use {} to highlight text',
					'value' => '',
					'admin_label' => true,
				),
				// params group
	            array(
	                'type' => 'param_group',
	                'save_always' => true,
	                'heading' => __( 'Working time and day', 'investment' ),
	                'param_name' => 'working_info',
	                'value' => urlencode( json_encode( array(
						                array(
						                    'time' => '8.00am - 5.30pm',
						                    'title' => 'Monday to Friday'					                    
						                ),
						                array(
						                    'time' => '9.00am - 2.00pm',
						                    'title' => 'Saturday'					                    
						                ),
						                array(
						                    'time' => 'Closed',
						                    'title' => 'Sunday'					                    
						                ),
						                ) ) ),
	                'params' => array(  
	                	array(
							'type' => 'textfield',
							'heading' => __('Day', 'investment'),
							'param_name' => 'title',
							'description' => '',
							'value' => '',
							'admin_label' => true,
						),	                
						array(
			                'type' => 'textfield',
			                'value' => '',
			                'heading' => 'Time duration',
			                'param_name' => 'time',
			            ),
			            
	                   
	                )
	            ),
			)
		) 
	);
	
}
class WPBakeryShortCode_Investment_working_hours extends WPBakeryShortCode {
}