<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $equal_height
 * @var $columns_placement
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $parallax_speed_bg
 * @var $parallax_speed_video
 * @var $content - shortcode content
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $equal_height = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = $css_animation = '';
$disable_element = '';
$output = $after_output = $overlay_bg = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

wp_enqueue_script( 'wpb_composer_front_js' );

$el_class = $this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation );

$extra_class = '';

if(in_array($bg_class, [ 'primary-bg', 'secondary-bg-dark', 'secondary-light-bg', 'secondary-dark-bg' ] )){
	$extra_class = 'has-darkbg-class';
}

// Bootstrap 5
if( $bg_class == 'primary-bg' ) $bg_class = 'bg-primary';
if( $bg_class == 'bg_gray' ) $bg_class = 'bg-light';
if( $bg_class == 'secondary-bg-dark' ) $bg_class = 'bg-dark';
if( $bg_class == 'secondary-dark-bg' ) $bg_class = 'bg-dark';
if( $bg_class == 'secondary-light-bg' ) $bg_class = 'bg-secondary-light';

$css_classes = array(
	'vc_row',
	'wpb_row',
	$padding_class,
	$bg_class,
	$overlay_class,
	$extra_class,
	//deprecated
	'vc_row-fluid',
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);
$css_classes_o = array(
	'row',
	'd-flex',
	$padding_class,
	$bg_class,
	$overlay_class,
	$extra_class,
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);

if( $overlay_bg == 'yes' ){
	$css_classes[] = 'overlay';
	$css_classes[] = $overlay_class;

	$css_classes_o[] = 'overlay';
	$css_classes_o[] = $overlay_class;

	if(in_array($overlay_class, [ 'dark-overlay', 'primary-overlay', 'secondary-overlay' ])){
		$css_classes[] = 'has-darkbg-class';
		$css_classes_o[] = 'has-darkbg-class';
	}
}

$bs5_placement_allies = [
	'top' => 'start',
	'middle' => 'center',
	'bottom' => 'end',
	'stretch' => 'stretch'
];

if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
		$css_classes_o[] = 'visually-hidden';
	} else {
		return '';
	}
}

if ( vc_shortcode_custom_css_has_property( $css, array(
		'border',
		'background',
	) ) || $video_bg || $parallax
) {
	$css_classes[] = 'vc_row-has-fill';
	$css_classes_o[] = 'bg-image';
}

if ( ! empty( $atts['gap'] ) ) {
	$css_classes[] = 'vc_column-gap-' . $atts['gap'];
	$css_classes_o[] = 'g-' . $atts['gap'];
}

$wrapper_attributes = $wrapper_attributes_o = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
	$wrapper_attributes_o[] = 'id="' . esc_attr( $el_id ) . '"';
}
if ( ! empty( $full_width ) ) {
	$wrapper_attributes[] = 'data-vc-full-width="true"';
	$wrapper_attributes[] = 'data-vc-full-width-init="false"';
	if ( 'stretch_row_content' === $full_width ) {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
	} elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
		$css_classes[] = 'vc_row-no-padding';
		$css_classes_o[] = 'p-0';
	}
	$after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = 'vc_row-o-full-height';
	$css_classes_o[] = 'h-100';
	if ( ! empty( $columns_placement ) ) {
		$flex_row = true;
		$css_classes[] = 'vc_row-o-columns-' . $columns_placement;
		$css_classes_o[] = 'justify-content-' . $bs5_placement_allies[$columns_placement];
		if ( 'stretch' === $columns_placement ) {
			$css_classes[] = 'vc_row-o-equal-height';
		}
	}
}

if ( ! empty( $equal_height ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-equal-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-content-' . $content_placement;
	
	$css_classes_o[] = 'align-items-' . $bs5_placement_allies[$content_placement];
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_row-flex';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

$parallax_speed = $parallax_speed_bg;
if ( $has_video_bg ) {
	$parallax = $video_bg_parallax;
	$parallax_speed = $parallax_speed_video;
	$parallax_image = $video_bg_url;
	$css_classes[] = 'vc_video-bg-container';
	wp_enqueue_script( 'vc_youtube_iframe_api_js' );
}

if ( ! empty( $parallax ) ) {
	wp_enqueue_script( 'vc_jquery_skrollr_js' );
	$wrapper_attributes[] = 'data-vc-parallax="' . esc_attr( $parallax_speed ) . '"'; // parallax speed
	$css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
	if ( false !== strpos( $parallax, 'fade' ) ) {
		$css_classes[] = 'js-vc_parallax-o-fade';
		$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
	} elseif ( false !== strpos( $parallax, 'fixed' ) ) {
		$css_classes[] = 'js-vc_parallax-o-fixed';
	}
}

if ( ! empty( $parallax_image ) ) {
	if ( $has_video_bg ) {
		$parallax_image_src = $parallax_image;
	} else {
		$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
		if ( ! empty( $parallax_image_src[0] ) ) {
			$parallax_image_src = $parallax_image_src[0];
		}
	}
	$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
}
if ( ! $parallax && $has_video_bg ) {
	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}
$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

if( vc_is_page_editable()):
	$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	$output .= wpb_js_remove_wpautop( $content );
	$output .= '</div>';
	$output .= $after_output;
else:
	$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( array_unique( $css_classes_o ) ) ) );
	$wrapper_attributes_o[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

	$output = '<div ' . implode( ' ', $wrapper_attributes_o ) . '>';
	$output .= wpb_js_remove_wpautop( $content );
	$output .= '</div>';
endif;

echo force_balance_tags($output);
