<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css
 * @var $el_id
 * @var $equal_height
 * @var $content_placement
 * @var $content - shortcode content
 * Shortcode class
 * @var WPBakeryShortCode_Vc_Row_Inner $this
 */
$el_class = $equal_height = $content_placement = $css = $el_id = '';
$extra_class = $padding_class = $bg_class = $overlay_class = '';
$disable_element = '';
$output = $after_output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );

extract( $atts );

$el_class = $this->getExtraClass( $el_class );
$css_classes = array(
	'vc_row',
	'wpb_row',
	// deprecated	
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);
$css_classes_o = array(
	'row',
	'd-flex',
	$padding_class,
	$bg_class,
	$overlay_class,
	$extra_class,
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);

$bs5_placement_allies = [
	'top' => 'start',
	'middle' => 'center',
	'bottom' => 'end',
	'stretch' => 'stretch'
];
if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}

if ( vc_shortcode_custom_css_has_property( $css, array(
	'border',
	'background',
) ) ) {
	$css_classes[] = 'vc_row-has-fill';
	$css_classes_o[] = 'bg-image';
}

if ( ! empty( $atts['gap'] ) ) {
	$css_classes[] = 'vc_column-gap-' . $atts['gap'];
	$css_classes_o[] = 'g-' . $atts['gap'];
}

if ( ! empty( $equal_height ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-equal-height';
}

if ( ! empty( $atts['rtl_reverse'] ) ) {
	$css_classes[] = 'vc_rtl-columns-reverse';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-content-' . $content_placement;
	$css_classes_o[] = 'align-items-' . $bs5_placement_allies[$content_placement];
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_row-flex';
}

$wrapper_attributes = $wrapper_attributes_o = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
	$wrapper_attributes_o[] = 'id="' . esc_attr( $el_id ) . '"';
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

if( vc_is_page_editable()):
	$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	$output .= wpb_js_remove_wpautop( $content );
	$output .= '</div>';
	$output .= $after_output;
else:
	$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( array_unique( $css_classes_o ) ) ) );
	$wrapper_attributes_o[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

	$output = '<div ' . implode( ' ', $wrapper_attributes_o ) . '>';
	$output .= wpb_js_remove_wpautop( $content );
	$output .= '</div>';
endif;

return $output;
