<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $columns_placement
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $parallax_speed_bg
 * @var $parallax_speed_video
 * @var $content - shortcode content
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = $css_animation = $html5_video_image = $mp4 = $ogb = $webm = '';
$disable_element = $overlay_bg = '';
$output = $after_output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

wp_enqueue_script( 'wpb_composer_front_js' );

$el_class = $this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation );

$extra_class = '';

if(in_array($bg_class, [ 'primary-bg', 'secondary-bg-dark', 'secondary-light-bg', 'secondary-dark-bg' ] )){
	$extra_class = 'has-darkbg-class';
}



// Bootstrap 5
if( $bg_class == 'primary-bg' ) $bg_class = 'bg-primary';
if( $bg_class == 'bg_gray' ) $bg_class = 'bg-light';
if( $bg_class == 'secondary-bg-dark' ) $bg_class = 'bg-dark';
if( $bg_class == 'secondary-dark-bg' ) $bg_class = 'bg-dark';
if( $bg_class == 'secondary-light-bg' ) $bg_class = 'bg-secondary-light';
if( $bg_class == 'default-bg' ) $bg_class = 'bg-body';

$type = 'section';
if($header == 'yes'){
	$type = 'header';
	$extra_class .= ($transparent_header == 'yes')? ' transparent-header default-bg' : ' default-bg';
} 
if($footer == 'yes'){
	$type = 'footer';
	$extra_class .= ' footer';
}
$top_arrow = ($top_arrow == 'yes')? 'top-arrow-'.$top_arrow : '';
$bottom_arrow =	($bottom_arrow == 'yes')? 'bottom-arrow-'.$top_arrow : '';

$css_classes = array(
	'vc_section',
	$el_class,
	$padding_class,
	$bg_class,
	$top_arrow,
	$bottom_arrow,
	$extra_class,	
	vc_shortcode_custom_css_class( $css ),
);

if( $overlay_bg == 'yes' ){
	$css_classes[] = 'overlay';
	$css_classes[] = $overlay_class;

	if(in_array($overlay_class, [ 'dark-overlay', 'primary-overlay', 'secondary-overlay' ])){
		$css_classes[] = 'has-darkbg-class';
	}
}

if( $video_bg == 'html5' ){
	$css_classes[] = 'section-video-play';
}

if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}

if ( vc_shortcode_custom_css_has_property( $css, array(
		'border',
		'background',
	) ) || $video_bg || $parallax
) {
	$css_classes[] = '';
}


$wrapper_attributes = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
if ( ! empty( $full_width ) ) {

	$after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = 'vc_row-o-full-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_section-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_section-flex';
}

$has_video_bg = ( $video_bg == 'yes' && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

$parallax_speed = $parallax_speed_bg;
if ( $has_video_bg ) {
	$parallax = $video_bg_parallax;
	$parallax_speed = $parallax_speed_video;
	$parallax_image = $video_bg_url;
	$css_classes[] = 'vc_video-bg-container';
	wp_enqueue_script( 'vc_youtube_iframe_api_js' );
}

if ( ! empty( $parallax ) ) {
	wp_enqueue_script( 'vc_jquery_skrollr_js' );
	$wrapper_attributes[] = 'data-vc-parallax="' . esc_attr( $parallax_speed ) . '"'; // parallax speed
	$css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
	if ( false !== strpos( $parallax, 'fade' ) ) {
		$css_classes[] = 'js-vc_parallax-o-fade';
		$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
	} elseif ( false !== strpos( $parallax, 'fixed' ) ) {
		$css_classes[] = 'js-vc_parallax-o-fixed';
	}
}

if ( ! empty( $parallax_image ) ) {

	$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image ) . '"';
}
if ( ! $parallax && $has_video_bg ) {
	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}

if( $video_bg == 'html5' ){
	$wrapper_attributes[] = 'data-class="bg-video"';
	$wrapper_attributes[] = 'data-poster="'.esc_url($html5_video_image).'"';
	$wrapper_attributes[] = 'data-webm="'.esc_url($webm).'"';
	$wrapper_attributes[] = 'data-ogv="'.esc_url($ogv).'"';
	$wrapper_attributes[] = 'data-mp4="'.esc_url($mp4).'"';
	wp_enqueue_script( 'vidbg' );
}
$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

$container_start =   $full_width == 'container'? '<div class="'.$full_width.'">' : '';
$container_end =   $full_width == 'container'? '</div>' : '';

$output .= '<'.$type.' ' . implode( ' ', $wrapper_attributes ) . '>'.$container_start;
$output .= wpb_js_remove_wpautop( $content );
$output .= $container_end.'</'.$type.'>';
$output .= $after_output;

echo force_balance_tags($output);
