<?php
/*Investment widget are - Main widget area + Subscription form widget area + Footer widget area*/
if ( !function_exists( 'investment_sidebars' ) ) {
	
	// Register Sidebars
	function investment_sidebars() {
		
		$args = array(
			 'id' => 'sidebar-1',
			'name' => __( 'Main Widget Area', 'investment' ),
			'before_title' => '<h4 class="small-h4 underline_small">',
			'after_title' => '</h4>',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>' 
		);
		register_sidebar( $args );

		if(function_exists('is_woocommerce')):
		$args = array(
			 'id' => 'sidebar-2',
			'name' => __( 'Shop Widget Area', 'investment' ),
			'before_title' => '<h4 class="small-h4 underline_small">',
			'after_title' => '</h4>',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>' 
		);
		register_sidebar( $args );
		endif;
		
		$args = array(
			 'id' => 'sidebar-portfolio',
			'name' => __( 'Portfolio Widget Area', 'investment' ),
			'before_title' => '<h4 class="small-h4 underline_small">',
			'after_title' => '</h4>',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>' 
		);
		if( !in_array('portfolio', investment_disable_post_type_arr()) ){
			register_sidebar( $args );
		}

		$args = array(
			 'id' => 'sidebar-service',
			'name' => __( 'Service Widget Area', 'investment' ),
			'before_title' => '<h4 class="small-h4 underline_small">',
			'after_title' => '</h4>',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>' 
		);
		if( !in_array('service', investment_disable_post_type_arr()) ){
			register_sidebar( $args );
		}


		$footer_widget_display = ot_get_option( 'footer_widget_area', 'on' );
		if( $footer_widget_display == 'on' ):
			$column = ot_get_option( 'footer_widget_area_column', '4' );
			for( $i = 1; $i <= $column; $i++ ){
				$args = array(
					'id' => 'footer-'.$i,
					'name' => __( 'Footer Widget Area ', 'investment' ).intval($i),
					'before_title' => '<h5>',
					'after_title' => '</h5>',
					'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
					'after_widget' => '</div>' 
				);
				register_sidebar( $args );
			}			
		endif;	

		if( function_exists( 'ot_get_option' ) ):
			$sidebarArr = ot_get_option( 'create_sidebar', array() );
			if( !empty( $sidebarArr ) ){
				$i = 2;
				foreach ($sidebarArr as $sidebar) {

					register_sidebar( array(
						'name' => esc_attr($sidebar['title']),
						'id' => 'sidebar-'.$i,
						'description' => esc_attr($sidebar['desc']),
						'before_widget' => '<div id="%1$s" class="widget %2$s">',
						'after_widget' => '</div>',
						'before_title' => '<h3 class="widget-title">',
						'after_title' => '</h3>',
					) );

					$i++;
				}
			}
		endif;	//if( function_exists( 'ot_get_option' ) ):	
	}
	add_action( 'widgets_init', 'investment_sidebars' );
	
} //!function_exists( 'investment_sidebars' )