<?php
class Investment_About_company_Widget extends WP_Widget {

  function __construct() {
    // Instantiate the parent object
    parent::__construct( 'investment_about_company_widget', 'Investment About company' );
  }

  function widget( $args, $instance ) {
    $title = ( !empty( $instance[ 'title' ] ) ) ? $instance[ 'title' ] : '';
    /** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
  	$image       = isset( $instance[ 'image' ] ) ? $instance[ 'image' ] : '';
  	$image_height       = isset( $instance[ 'image_height' ] ) ? $instance[ 'image_height' ] : '48';
    $description = isset( $instance[ 'description' ] )? $instance[ 'description' ] : '';

    echo $args['before_widget'];
    
		
    if ( !empty($title) ) {
      echo $args[ 'before_title' ] . esc_attr($title) . $args[ 'after_title' ];
    } 
	
		
	  echo '<div class="footer-content">
							<img src="'.esc_url( $image ).'" class="footer-logo" height="'.intval($image_height).'" alt="">
							<p class="smaller">'.$description.'</p>
						</div>
					';
    echo $args['after_widget'];
  }

  function update( $new_instance, $old_instance ) {
    // Save widget options
    $instance = array();
    $instance[ 'title' ]     = sanitize_text_field( $new_instance[ 'title' ] );
    $instance['image'] = ( ! empty( $new_instance['image'] ) ) ? strip_tags( $new_instance['image'] ) : '';
    $instance['image_height'] = ( ! empty( $new_instance['image_height'] ) ) ? strip_tags( $new_instance['image_height'] ) : '';
    $instance['description'] = ( ! empty( $new_instance['description'] ) ) ? strip_tags( $new_instance['description'] ) : '';

    return $instance;
  }

  function form( $instance ) {
    $title     = isset( $instance[ 'title' ] ) ? esc_attr( $instance[ 'title' ] ) : '';
    $image = isset( $instance[ 'image' ] )? $instance[ 'image' ] : INVESTMENT_ASSETS.'/images/logo-white.png';
    $image_height = isset( $instance[ 'image_height' ] )? $instance[ 'image_height' ] : '48';
    $description = isset( $instance[ 'description' ] )? $instance[ 'description' ] : 'Founded in 1980, Investment Expert is one of the largest and most experienced global private equity firms. We have established a team investment professionals, focused on buyouts and growth equity investments.';
    ?>
    <p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>">
        	<?php _e( 'Title:', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
    <p>
		<label for="<?php echo $this->get_field_id( 'image' ); ?>"><?php _e( 'Logo:', 'investment' ); ?></label> 
		<div class="investment-upload-container"><input type="text" name="<?php echo $this->get_field_name( 'image' ); ?>" value="<?php echo esc_url( $image ) ?>" id="perch-generator-attr-<?php echo $this->get_field_id( 'image' ); ?>" class="widefat perch-generator-attr perch-generator-upload-value" />
		<a href="javascript:;" class="button investment-upload-button"><img src="<?php echo admin_url( '/images/media-button.png' ) ?>" alt="<?php echo __( 'Media manager', 'investment' )?>" /> <?php echo __( 'Media manager', 'investment' ) ?></a>
    </div>
		<img src="<?php echo esc_url( $image ) ?>" alt="image">			
	</p>  
    <p><label for="<?php echo esc_attr($this->get_field_id( 'image_height' )); ?>">
        	<?php _e( 'Image height(max):', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'image_height' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'image_height' )); ?>" type="number" value="<?php echo esc_attr($image_height); ?>" /></p>
    <p>
    <p>
      <label for="<?php echo $this->get_field_id( 'description' ); ?>"><?php _e( 'Description:', 'investment' ); ?></label> 
      <textarea cols="20" rows="4" class="widefat" id="<?php echo $this->get_field_id( 'description' ); ?>" name="<?php echo $this->get_field_name( 'description' ); ?>"><?php echo esc_attr( $description ); ?></textarea>
    </p>

    <?php
  }
}