<?php
class Investment_Download_link_Widget extends WP_Widget
{

  function __construct()
  {
    // Instantiate the parent object
    parent::__construct('investment_download_link_widget', 'Investment Download link');
  }

  public function get_background_color($dark = false)
  {
    if ($dark) {
      return array('primary-bg', 'secondary-bg', 'secondary-light-bg', 'dark-bg');
    } else {
      return array(
        'primary-bg' => 'Primary color',
        'secondary-bg' => 'Secondary color',
        'secondary-light-bg' => 'Secondary light color',
        'dark-bg' => 'Dark color',
        'grey-bg' => 'Grey color',
        'tra-bg' => 'Transparent color',
        'white-bg' => 'White color'
      );
    }
  }

  public function get_dropdown_html($instance)
  {
    $bg     = isset($instance['bg']) ? esc_attr($instance['bg']) : 'secondary-bg';

?>
    <p><label for="<?php echo esc_attr($this->get_field_id('bg')); ?>">
        <?php _e('Background color', 'investment'); ?></label>
      <select class="widefat" id="<?php echo esc_attr($this->get_field_id('bg')); ?>" name="<?php echo esc_attr($this->get_field_name('bg')); ?>">
        <?php
        $colors = $this->get_background_color();
        foreach ($colors as $key => $value) {
          $selected = ($key == $bg) ? ' selected="selected"' : '';
          echo '<option value="' . esc_attr($key) . '"' . $selected . '>' . esc_attr($value) . '</option>';
        }
        ?>
      </select>
    </p>
  <?php
  }

  function widget($args, $instance)
  {

    $dark_colors = $this->get_background_color(true);
    $title = (!empty($instance['title'])) ? $instance['title'] : '';
    $link_text = isset($instance['link_text']) ? $instance['link_text'] : '';
    $url = isset($instance['url']) ? $instance['url'] : '';
    $icon = (!empty($instance['icon'])) ? $instance['icon'] : 'fa fa-file-pdf-o';
    $bg     = isset($instance['bg']) ? esc_attr($instance['bg']) : 'secondary-bg';
    $btn_style     = 'btn-' . str_replace('-bg', '', $bg);
    //$bg .= in_array($bg, $dark_colors)? ' has-darkbg-class' : '';
    //print_r($instance);
    echo $args['before_widget'];
    echo (!empty($title)) ? $args['before_title'] . esc_attr($title) . $args['after_title'] : '';

    $btn_classes = [
      'btn',
      'pe-10',
      'text-start',
      'd-flex',
      'align-items-lg-start',
      'align-items-center',
      $btn_style,
      sanitize_title(esc_attr($link_text))
    ];

    echo '<div class="brochures clearfix d-grid">
          <a href="' . esc_url($url) . '" target="_blank" class="' . join(' ', $btn_classes) . '"><i class="' . esc_attr($icon) . ' pt-1" aria-hidden="true"></i><strong>' . esc_attr($link_text) . '</strong></a>
          </div>';
    echo $args['after_widget'];
  }

  function update($new_instance, $old_instance)
  {
    // Save widget options
    $instance = array();
    $instance['title']     = sanitize_text_field($new_instance['title']);
    $instance['link_text'] = (!empty($new_instance['link_text'])) ? strip_tags($new_instance['link_text']) : '';
    $instance['url'] = (!empty($new_instance['url'])) ? esc_url($new_instance['url']) : '';
    $instance['icon']    =  $new_instance['icon'];
    $instance['bg']    =  $new_instance['bg'];

    return $instance;
  }

  function form($instance)
  {

    $title     = isset($instance['title']) ? esc_attr($instance['title']) : '';
    $link_text = isset($instance['link_text']) ? $instance['link_text'] : 'Download Company Brochures';
    $url = isset($instance['url']) ? $instance['url'] : '#';
    $icon = (!empty($instance['icon'])) ? $instance['icon'] : 'fa fa-file-pdf-o';
  ?>
    <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
        <?php _e('Title:', 'investment'); ?></label>
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
    </p>
    <p>
      <?php $this->get_dropdown_html($instance); ?>

      <label for="<?php echo $this->get_field_id('link_text'); ?>"><?php _e('Download button text:', 'investment'); ?></label>
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id('link_text')); ?>" name="<?php echo esc_attr($this->get_field_name('link_text')); ?>" type="text" value="<?php echo esc_attr($link_text); ?>" />
    </p>
    <p>
      <label for="<?php echo $this->get_field_id('url'); ?>"><?php _e('Download URL:', 'investment'); ?></label>
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id('url')); ?>" name="<?php echo esc_attr($this->get_field_name('url')); ?>" type="text" value="<?php echo esc_url($url); ?>" />
    </p>
    <p><label for="<?php echo esc_attr($this->get_field_id('icon')); ?>">
        <?php _e('Button Icon class', 'investment'); ?></label>
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id('icon')); ?>" name="<?php echo esc_attr($this->get_field_name('icon')); ?>" type="text" value="<?php echo esc_attr($icon); ?>" />
    </p>
    <p>
  <?php
  }
}
