<?php
if(class_exists('es_cls_widget')){
	class Investment_es_cls_widget extends es_cls_widget{
		public static function load_subscription($arr){
			extract($arr);
			$url = "'" . home_url() . "'";
			$output = "";
			
			global $es_includes;
			if (!isset($es_includes) || $es_includes !== true) { 
				$es_includes = true;
			}

			$output .= "<div>";

			$output .=  '<div class="es_msg"><span id="es_msg_pg"></span></div>';
			


			$output .= '<div class="input-group">
								      	<input class="es_textbox_class form-control" placeholder="'.esc_attr($placeholder).'" type="email" name="es_txt_email_pg" id="es_txt_email_pg" required>
								      	<input type="hidden"  id="es_txt_name_pg" class="es_textbox_class" name="es_txt_name_pg" value="">
								      	<span class="input-group-btn"><input type="submit" id="es_txt_button_pg" class="es_textbox_button es_submit_button btn btn-default" name="es_txt_button_pg" value="&nbsp;"></span>
								    </div>';

			$output .=  '<input name="es_txt_group_pg" id="es_txt_group_pg" value="'.$group.'" type="hidden">';
			$output .= wp_nonce_field( 'es-subscribe', 'es-subscribe', true, false );
			$output .=  '</div>';
			return $output;
		}
	}//end Investment_es_cls_widget

	function investment_es_subbox( $args= array()){
		echo Investment_es_cls_widget::load_subscription($args);
	}//investment_es_subbox
}
/**
 * Investment class used to implement a Footer Instafeed Carouel widget. 
 */
class Investment_Footer_Subscription_Form extends WP_Widget {
	
	public function __construct() {
		$widget_ops = array(
			 'classname' => 'news-letter',
			'description' => '' 
		);
		parent::__construct( 'footer-subscription-form', __( 'Investment Newsletter form', 'investment' ), $widget_ops );
	}
	

	public function widget( $args, $instance ) {

		if ( !isset( $args[ 'widget_id' ] ) ) {
			$args[ 'widget_id' ] = $this->id;
		} //!isset( $args[ 'widget_id' ] )

		
		$title = ( !empty( $instance[ 'title' ] ) ) ? $instance[ 'title' ] : '';
		$desc     = isset( $instance[ 'desc' ] ) ? esc_attr( $instance[ 'desc' ] ) : '';
		$button_text = isset( $instance[ 'button_text' ] ) ? esc_attr( $instance[ 'button_text' ] ) : 'icon-arrows-slim-right';
		$placeholder = ( !empty( $instance[ 'placeholder' ] ) ) ? $instance[ 'placeholder' ] : 'YOUR EMAIL ADDRESS';
		$group = ( !empty( $instance[ 'group' ] ) ) ? $instance[ 'group' ] : '';
		
		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		echo $args[ 'before_widget' ];
		echo ( !empty( $title ) ) ? $args[ 'before_title' ] . esc_attr($title) . $args[ 'after_title' ] : '';
		echo ( !empty( $desc ) ) ? '<p>'.esc_attr($desc).'</p>' : '';

				if( class_exists('ES_Shortcode')){
					$form_args = array(
						'form_button_style' => 'icon',
						'form_button_icon' => $button_text,
						'enable_name' => false,
						'input_group' => true,
						'email_place_holder' => $placeholder,
						'group' => $group
					);
					echo Investment_ES_Shortcode::render_shortcode($form_args);									
				}
		
				else{
					echo is_user_logged_in()? 'Please Install Theme Required & Recommended Plugins.' : '';
				}
			
		echo (isset($args[ 'after_widget' ]))?$args[ 'after_widget' ] : '</div>';
		
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance                = $old_instance;
		$instance[ 'title' ]     = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'desc' ]    =  $new_instance[ 'desc' ];
		$instance[ 'placeholder' ]     = $new_instance[ 'placeholder' ];
		$instance[ 'group' ]    =  $new_instance[ 'group' ];
		return $instance;
	}

	public function form( $instance ) {
		$title     = isset( $instance[ 'title' ] ) ? esc_attr( $instance[ 'title' ] ) : 'Newsletter';
		$desc     = isset( $instance[ 'desc' ] ) ? $instance[ 'desc' ] : 'Signup for our latest case studies.';
		$placeholder = ( !empty( $instance[ 'placeholder' ] ) ) ? $instance[ 'placeholder' ] : 'Enter your email address..';
		
		$group = ( !empty( $instance[ 'group' ] ) ) ? $instance[ 'group' ] : '';
		
		?>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>">
        	<?php _e( 'Title:', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id( 'desc' )); ?>">
        	<?php _e( 'Description:', 'investment' ); ?></label>
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id( 'desc' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'desc' )); ?>"><?php echo sanitize_text_field($desc); ?></textarea></p>

        <p><label for="<?php echo esc_attr($this->get_field_id( 'placeholder' )); ?>">
        	<?php _e( 'Email Placeholder:', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'placeholder' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'placeholder' )); ?>" type="text" value="<?php echo esc_attr($placeholder); ?>" /></p>

     

        <?php if(class_exists('ES_Common')): ?>
		<p>
			<label for="widget-email-subscribers-2-es_group"><?php esc_html_e( 'Subscriber List' ); ?></label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'group' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'group' ) ); ?>" class="widefat" style="width:100%;">
				<?php
					$lists_dropdown = ES_Common::prepare_list_dropdown_options( $group );
					$allowedtags    = ig_es_allowed_html_tags_in_esc();
					echo wp_kses( $lists_dropdown, $allowedtags );
				?>
			</select>
			<a href="<?php echo admin_url('admin.php?page=es_lists&action=new') ?>" target="_blank"> Create a list</a>
		</p>
        
		<?php
		endif;      
        
	}
}


