<?php
class Investment_How_can_We_Help_Widget extends WP_Widget {
	
	public function __construct() {
		$widget_ops = array(
			 'classname' => 'widget_how_can_we_help',
			'description' => 'Display button link with Title and description' 
		);
		parent::__construct( 'widget-how-can-we-help', __( 'Investment How can we help', 'investment' ), $widget_ops );
	}

	public function get_background_color($dark = false){
		if( $dark ){
			return array( 'primary-bg', 'secondary-bg', 'secondary-light-bg', 'dark-bg' );
		}else{
			return array( 
				'primary-bg' => 'Primary color', 
				'secondary-bg' => 'Secondary color',
				'secondary-light-bg' => 'Secondary light color', 
				'dark-bg' => 'Dark color',
				'grey-bg' => 'Grey color', 
				'tra-bg' => 'Transparent color', 
				'white-bg' => 'White color' 
			);
		}
	}

	public function get_bg_dropdown_html($instance){
		$bg     = isset( $instance[ 'bg' ] ) ? esc_attr( $instance[ 'bg' ] ) : 'primary-bg';

		?>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'bg' )); ?>">
        	<?php _e( 'Background color', 'investment' ); ?></label>
        <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'bg' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'bg' )); ?>">
        	<?php
        	$colors = $this->get_background_color();        	
        	foreach ($colors as $key => $value) {
        		$selected = ($key == $bg)? ' selected="selected"' : '';
        		echo '<option value="'.esc_attr($key).'"'.$selected.'>'.esc_attr($value).'</option>';
        	}
        	?>
        </select></p>
        <?php
	}
	

	public function widget( $args, $instance ) {

		if ( !isset( $args[ 'widget_id' ] ) ) {
			$args[ 'widget_id' ] = $this->id;
		} //!isset( $args[ 'widget_id' ] )

		$dark_colors = $this->get_background_color(true);
		$title = ( !empty( $instance[ 'title' ] ) ) ? $instance[ 'title' ] : 'How Can We Help?';
		$desc     = isset( $instance[ 'desc' ] ) ? esc_attr( $instance[ 'desc' ] ) : '';
		
		$button_text = ( !empty( $instance[ 'button_text' ] ) ) ? $instance[ 'button_text' ] : '';
		$link = ( !empty( $instance[ 'link' ] ) ) ? $instance[ 'link' ] : '#';		
		$icon = ( !empty( $instance[ 'icon' ] ) ) ? $instance[ 'icon' ] : 'fa fa-envelope';	
		$bg     = isset( $instance[ 'bg' ] ) ? esc_attr( $instance[ 'bg' ] ) : 'primary-bg';
		$bg_color = 'bg-'.str_replace('-bg', '', $bg);
		$white_color = in_array($bg, $dark_colors)? ' has-darkbg-class' : '';
		$classes = [
			'help',
			'clearfix',
			$bg_color,
			$white_color
		];
		$btn_style = ( $bg_color == 'bg-primary' )? 'secondary' : 'primary';
		$btn_classes = [
			'btn',	
			'btn-sm',		
			'btn-'.$btn_style,
			'border-'.$btn_style.'-hover',
			sanitize_title(esc_attr($button_text))
		];
		
		?>
		<div class="<?php echo join(' ', $classes) ?>">
			<h4 class="small-h4 white"><?php echo esc_attr($title); ?></h4>
			<p class="caps_large"><?php echo force_balance_tags(nl2br($desc)); ?></p>
			<?php if( $button_text != '' ): ?>
				<div class="help-btn-wrap"><a href="<?php echo esc_url($link); ?>" class="<?php echo join(' ', $btn_classes) ?>"><i class="<?php echo esc_attr($icon) ?>" aria-hidden="true"></i><?php echo esc_attr($button_text); ?></a></div>
			<?php endif; ?>
		</div>
		<?php
		
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance                = $old_instance;
		$instance[ 'title' ]     = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'desc' ]    =  $new_instance[ 'desc' ];
		$instance[ 'button_text' ]    =  $new_instance[ 'button_text' ];
		$instance[ 'link' ]    =  $new_instance[ 'link' ];
		$instance[ 'icon' ]    =  $new_instance[ 'icon' ];
		$instance[ 'bg' ]    =  $new_instance[ 'bg' ];
		return $instance;
	}

	public function form( $instance ) {
		$title     = isset( $instance[ 'title' ] ) ? esc_attr( $instance[ 'title' ] ) : 'How Can We Help?';
		$desc     = isset( $instance[ 'desc' ] ) ? $instance[ 'desc' ] : 'At vero eos et accusam et justou dolores et ea rebum tet clita kasd gubergren no sea takimata.';
		$button_text = ( !empty( $instance[ 'button_text' ] ) ) ? $instance[ 'button_text' ] : 'Get in touch';
		$link = ( !empty( $instance[ 'link' ] ) ) ? $instance[ 'link' ] : '#';
		$icon = ( !empty( $instance[ 'icon' ] ) ) ? $instance[ 'icon' ] : 'fa fa-envelope';

		$this->get_bg_dropdown_html($instance);
		?>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>">
        	<?php _e( 'Title:', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id( 'desc' )); ?>">
        	<?php _e( 'Description:', 'investment' ); ?></label>
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id( 'desc' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'desc' )); ?>"><?php echo sanitize_text_field($desc); ?></textarea></p>

        
        <p><label for="<?php echo esc_attr($this->get_field_id( 'button_text' )); ?>">
        	<?php _e( 'Button Text:', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'button_text' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'button_text' )); ?>" type="text" value="<?php echo esc_attr($button_text); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id( 'link' )); ?>">
        	<?php _e( 'Button URL:', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link' )); ?>" type="text" value="<?php echo esc_attr($link); ?>" /></p>
        
        <p><label for="<?php echo esc_attr($this->get_field_id( 'icon' )); ?>">
        	<?php _e( 'Button Icon class', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'icon' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'icon' )); ?>" type="text" value="<?php echo esc_attr($icon); ?>" /></p>
		<?php
	}
}


