<?php
class Investment_Widget_Portfolio_Corporation_Details extends WP_Widget {
	
	function __construct() {
		$widget_ops = array('classname' => 'corporation-brand', 'description' => __( "Widget display( corporation info, Brochures Link, Testimonials ) only in single portfolio widget area", "investment") );
		// Instantiate the parent object
		parent::__construct( 'investment_portfolio_company_info_widget', __('Investment Portfolio\'s Info', 'investment'), $widget_ops );
	}
	
	function widget( $args, $instance ) {

		if(is_singular('portfolio')){
			$type = ( !empty( $instance[ 'type' ] ) ) ? $instance[ 'type' ] : 'corporation_info';
			if ( !$type ) 	$type = 'corporation_info';			
			if($type == 'corporation_info'){
				get_template_part('template-parts/portfolio/corporation', 'details');
			}elseif ($type == 'download_link') {
				get_template_part('template-parts/portfolio/download', 'links');
			}elseif ($type == 'testimonials') {
				get_template_part('template-parts/portfolio/testimonials', '');
			}			
		}
		
	}
	
	function update( $new_instance, $old_instance ) {
		$instance[ 'type' ]    = $new_instance[ 'type' ];
		return $instance;
	}
	
	function form( $instance ) {
		$type    = isset( $instance[ 'type' ] ) ? $instance[ 'type' ] : 'corporation_info';
		?>
		<p><label for="<?php echo esc_attr($this->get_field_id( 'type' )); ?>"><?php _e( 'Portfolio Info Display', 'investment' ); ?></label>
		<select id="<?php echo esc_attr($this->get_field_id( 'type' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'type' )); ?>">
			<option value="corporation_info"<?php echo ($type == 'corporation_info')? ' selected="selected"' : ''  ?>>corporation info</option>
			<option value="download_link"<?php echo ($type == 'download_link')? ' selected="selected"' : ''  ?>>Download Brochures Link</option>
			<option value="testimonials"<?php echo ($type == 'testimonials')? ' selected="selected"' : ''  ?>>Portfolio Testimonials</option>
		</select>
        
		<?php		
	}
}