<?php
class Investment_Testimonial_Widget extends WP_Widget {

  function __construct() {
    // Instantiate the parent object
    parent::__construct( 'investment_testimonial_widget', 'Investment Testimonial' );
  }

  function widget( $args, $instance ) {
    $title = ( !empty( $instance[ 'title' ] ) ) ? $instance[ 'title' ] : '';
    $image       = isset( $instance[ 'image' ] ) ? $instance[ 'image' ] : '';
    $description = isset( $instance[ 'description' ] )? $instance[ 'description' ] : '';
    $name = isset( $instance[ 'name' ] )? $instance[ 'name' ] : '';
    $designation = isset( $instance[ 'designation' ] )? $instance[ 'designation' ] : '';
    //print_r($instance);
    echo $args['before_widget'];
    echo ( !empty( $title ) ) ? $args[ 'before_title' ] . esc_attr($title) . $args[ 'after_title' ] : '';

    echo '<div class="testimonial-content clearfix">
            '.investment_get_svg_icon('quote', 'testimonial-icon').'
            <p class="smaller-italic">'.nl2br($description).' </p>
          </div>
          <div class="testimonial clearfix">
                <img src="'.esc_url( $image ).'" alt="">
                <div class="content">
                  <span class="h_small">'.$name.'</span>
                  <p class="smaller-italic">'.$designation.'</p>
                </div>
              </div>';      
    echo $args['after_widget'];
  }

  function update( $new_instance, $old_instance ) {
    // Save widget options
    $instance = array();
    $instance[ 'title' ]     = sanitize_text_field( $new_instance[ 'title' ] );
    $instance['image'] = ( ! empty( $new_instance['image'] ) ) ? strip_tags( $new_instance['image'] ) : '';
    $instance['description'] = ( ! empty( $new_instance['description'] ) ) ? strip_tags( $new_instance['description'] ) : '';
    $instance['name'] = ( ! empty( $new_instance['name'] ) ) ? strip_tags( $new_instance['name'] ) : '';
    $instance['designation'] = ( ! empty( $new_instance['designation'] ) ) ? strip_tags( $new_instance['designation'] ) : '';


    return $instance;
  }

  function form( $instance ) {

    $title     = isset( $instance[ 'title' ] ) ? esc_attr( $instance[ 'title' ] ) : '';
    $image = isset( $instance[ 'image' ] )? $instance[ 'image' ] : INVESTMENT_ASSETS.'/images/foto-man.png';   
    $description = isset( $instance[ 'description' ] )? $instance[ 'description' ] : '“There are two things I look for in a financial adviser. Firstly, a thorough, up to date knowledge of all aspects of government rules and regulations pertaining to superannuation and investments.';
    $name = isset( $instance[ 'name' ] )? $instance[ 'name' ] : 'Alexa Von Tobel';
    $designation = isset( $instance[ 'designation' ] )? $instance[ 'designation' ] : 'CEO Finance Consult Manager';
    ?>
    <p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>">
          <?php _e( 'Title:', 'investment' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
    <p>
		<label for="<?php echo $this->get_field_id( 'image' ); ?>"><?php _e( 'Image Upload:', 'investment' ); ?></label> 
		<div class="investment-upload-container"><input type="text" name="<?php echo $this->get_field_name( 'image' ); ?>" value="<?php echo esc_url( $image ) ?>" id="perch-generator-attr-<?php echo $this->get_field_id( 'image' ); ?>" class="widefat perch-generator-attr perch-generator-upload-value" />
		<a href="javascript:;" class="button investment-upload-button"><img src="<?php echo admin_url( '/images/media-button.png' ) ?>" alt="<?php echo __( 'Media manager', 'investment' )?>" /> <?php echo __( 'Media manager', 'investment' ) ?></a>
    </div>
		<img src="<?php echo esc_url( $image ) ?>" alt="">			
	 </p>
   
    <p>
      <label for="<?php echo $this->get_field_id( 'description' ); ?>"><?php _e( 'Description:', 'investment' ); ?></label> 
      <textarea cols="20" rows="4" class="widefat" id="<?php echo $this->get_field_id( 'description' ); ?>" name="<?php echo $this->get_field_name( 'description' ); ?>"><?php echo esc_attr( $description ); ?></textarea>
    </p>
    <p>
      <label for="<?php echo $this->get_field_id( 'name' ); ?>"><?php _e( 'Name:', 'investment' ); ?></label> 
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'name' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'name' )); ?>" type="text" value="<?php echo esc_attr($name); ?>" />
    </p>
    <p>
      <label for="<?php echo $this->get_field_id( 'designation' ); ?>"><?php _e( 'Designation:', 'investment' ); ?></label> 
      <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'designation' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'designation' )); ?>" type="text" value="<?php echo esc_attr($designation); ?>" />
    </p>

    <?php
  }
}