(function () {
    'use strict';
    var nc = jQuery.noConflict();
    nc(document).ready(function () {
        var osmMapElms = [];
        var osmMapElms = nc('.openstreet-canvas');
        if (osmMapElms.length > 0) {
            nc.map(osmMapElms, function (mapElm, i) {
                var mapID = nc(mapElm).attr('id');
                var mapLat = nc(mapElm).data('lat');
                var mapLong = nc(mapElm).data('long');
                var mapZoom = nc(mapElm).data('lat');
                var mapMarker = nc(mapElm).data('marker');
                if (typeof L !== 'undefined') {
                    var latlng = L.latLng(mapLat, mapLong);

                    var mapMarkerIcon = L.icon({
                        iconUrl: mapMarker,
                        iconSize: [60, 60]
                    });
                    var osmMap = L.map(mapID, {
                        center: latlng,
                        zoom: mapZoom

                    });
                    L.marker(latlng, {icon: mapMarkerIcon}).addTo(osmMap);
                    L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png').addTo(osmMap);
                    osmMapElms[i] = osmMap;
                }
            });
            nc(".investment-tabs-wrapper a.nav-link").on('shown.bs.tab', function (e) {
                var mapWrap = nc(this).attr('href');
                var osmMapIdx = nc(mapWrap).find('.openstreet-canvas').data('mapindex');

                //var osmMap = L.get;
                if(osmMapElms[osmMapIdx]){
                    osmMapElms[osmMapIdx].invalidateSize();
                }

            });
        }
    });
})(jQuery);
