<?php
/**
 * The template for displaying comments
 *
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-and-replay bg-light">

	
	<?php if ( have_comments() ) : ?>
		<div class="block-comments">
		<h4 class="small-h4">
			<?php
				printf( _nx( '<span class="primary-color">%1$s</span> Comments', '<span class="primary-color">%1$s</span> Comments', get_comments_number(), 'comments title', 'investment' ), get_comments_number());
			?>
		</h4>

		<?php investment_comment_nav(); ?>

		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'style'       => 'ol',
					'short_ping'  => true,
					'avatar_size' => 80,
					'callback' => 'investment_comment_callback'
				) );
			?>
		</ol><!-- .comment-list -->

		<?php investment_comment_nav(); ?>
		</div>

	<?php endif; // have_comments() ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php _e( 'Comments are closed.', 'investment' ); ?></p>
	<?php endif; ?>

	<?php investment_comment_form(); ?>

</div><!-- .comments-area -->
