<?php
if(WP_DEBUG){
	define('INVESTMENT_VERSION', '2.4.3--'.time());
}else{
	define('INVESTMENT_VERSION', '2.4.3');
}

define('INVESTMENT_URI', get_template_directory_uri());
define('INVESTMENT_ASSETS', INVESTMENT_URI . '/assets');
define('INVESTMENT_DIR', get_template_directory());
// Set content width value based on the theme's design
if (!isset($content_width))
	$content_width = 1170;

if (!function_exists('investment_theme_features')) {

	// Register Theme Features
	function investment_theme_features()
	{

		// Add theme support for Automatic Feed Links
		add_theme_support('automatic-feed-links');

		// Add theme support for Post Formats
		add_theme_support('post-formats', array('status', 'quote', 'gallery', 'video', 'audio', 'link'));

		// Add theme support for Featured Images
		add_theme_support('post-thumbnails');

		// add theme support for woocommerce
		add_theme_support('woocommerce');

		// Set custom thumbnail dimensions
		set_post_thumbnail_size(827, 407, true);
		add_image_size('investment-post-thumbnail', 832, 554, true);
		add_image_size('investment-900x700-crop', 900, 700, true);
		add_image_size('investment-600x600-crop', 600, 600, true);
		add_image_size('investment-500x340-crop', 500, 340, true);
		add_image_size('investment-530x335-crop', 530, 335, true);
		add_image_size('investment-630x335-crop', 630, 335, true);
		add_image_size('investment-428x227-crop', 428, 227, true);
		add_image_size('investment-400x400-crop', 400, 400, true);
		add_image_size('investment-360x227-crop', 360, 227, true);
		add_image_size('investment-300x300-crop', 300, 300, true);
		add_image_size('investment-250x250-crop', 250, 250, true);
		add_image_size('investment--x125-crop', '', 125, true);


		// Add theme support for Custom Background
		$background_args = array(
			'default-color'          => '#fff',
			'default-image'          => '',
			'default-repeat'         => '',
			'default-position-x'     => ''
		);
		add_theme_support('custom-background', $background_args);


		// Add theme support for HTML5 Semantic Markup
		add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption'));

		// Add theme support for document Title tag
		add_theme_support('title-tag');

		// Add theme support for custom CSS in the TinyMCE visual editor
		if (is_rtl()) {
			add_editor_style('css/editor-style-rtl.css', investment_fonts_url());
		} else {
			add_editor_style('css/editor-style.css', investment_fonts_url());
		}


		// Add theme support for Translation
		load_theme_textdomain('investment', get_template_directory() . '/assets/language');

		// Add theme support for selective refresh for widgets.
		add_theme_support('customize-selective-refresh-widgets');

		// Add support for Block Styles.
		add_theme_support('wp-block-styles');

		// Add support for full and wide align images.
		add_theme_support('align-wide');

		// Add support for editor styles.
		add_theme_support('editor-styles');

		// Add support for responsive embedded content.
		add_theme_support('responsive-embeds');

		add_theme_support('control-block-patterns');
	}
	add_action('after_setup_theme', 'investment_theme_features');
}

// deactivate new block editor
function investment_widgets_block_editor()
{
	remove_theme_support('widgets-block-editor');
}
add_action('after_setup_theme', 'investment_widgets_block_editor');

if (!function_exists('investment_navigation_menus')) {

	// Register Navigation Menus
	function investment_navigation_menus()
	{

		$locations = array(
			'primary' => __('Header Menu', 'investment'),
			'footer' => __('Footer Menu', 'investment'),
		);
		register_nav_menus($locations);
	}
	add_action('init', 'investment_navigation_menus');
} //!function_exists( 'investment_navigation_menus' )

function investment_filter_shortcode_content()
{
	remove_filter('the_content', 'wpautop');
	add_filter('the_content', 'wpautop', 12);

	add_filter('the_content', 'investment_remove_empty_p', 20, 1);
}

function investment_remove_empty_p($content)
{
	$content = force_balance_tags($content);
	return preg_replace('#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content);
}

add_filter('https_ssl_verify', '__return_false');


// Required: include OptionTree.
require(INVESTMENT_DIR . '/option-tree/ot-loader.php');

//admin functions 
include INVESTMENT_DIR . '/admin/functions.php';

//frontent functions
include INVESTMENT_DIR . '/includes/functions.php';


// Portfolio function
require(INVESTMENT_DIR . '/includes/portfolio-functions.php');
// require(INVESTMENT_DIR . '/includes/control-elementor.php');