<?php
if( !function_exists('investment_hex2rgb') ):
function investment_hex2rgb( $color, $opacity='1' ) {
  $color = trim( $color, '#' );

  if ( strlen( $color ) == 3 ) {
    $r = hexdec( substr( $color, 0, 1 ).substr( $color, 0, 1 ) );
    $g = hexdec( substr( $color, 1, 1 ).substr( $color, 1, 1 ) );
    $b = hexdec( substr( $color, 2, 1 ).substr( $color, 2, 1 ) );
  } else if ( strlen( $color ) == 6 ) {
    $r = hexdec( substr( $color, 0, 2 ) );
    $g = hexdec( substr( $color, 2, 2 ) );
    $b = hexdec( substr( $color, 4, 2 ) );
  } else {
    return '';
  }
  if(!$opacity) return "{$r}, {$g}, {$b}";

  return "rgba( {$r}, {$g}, {$b}, {$opacity} )";
}
endif;

function investment_compress($buffer) {
    //Remove CSS comments
    $buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
    //Remove tabs, spaces, newlines, etc.
    $buffer = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $buffer);
    return $buffer;
}

function investment_border_css($option_id, $selector = ''){
   $output = '';
  $properties = '';
   $border = ot_get_option($option_id, array());
   if ( is_array($border) && !empty($border)) {
      foreach ($border as $key => $value) :
        if( $value != '' ): 
         switch ($key) {
          case 'color':
                $properties .= 'border-color:' . $value . ';';
                break;
            case 'style':
                $properties .= 'border-style:' . $value . ';';
                break; 
            case 'width':
                $properties .= 'border-width:' . esc_attr($value) . 'px;';
                break;
           
         }
        endif; 
      endforeach;
      $output .= ($properties != '')?"\n" . esc_attr($selector) . ' { ' . $properties . '}' . "\n" : '';
   }
   return $output;
}

function investment_background_css($option_id, $selector = '') {
    $background = ot_get_option($option_id, array());
    $output     = investment__background_css($background, $selector);
    
    return $output;
}

function investment__background_css($background = array(), $selector = '') {
    $output = '';
    $properties = '';
    if ( is_array($background) && !empty($background)) {
        foreach ($background as $key => $value) :
            if( $value != '' ):                
            switch (str_replace('background-', '', $key)) {
                case 'color':
                    $properties .= 'background-color:' . $value . ';';                    
                    break;
                case 'image':
                    $properties .= 'background-image:url(' . esc_url($value) . ');';
                    break; 
                case 'repeat':
                    $properties .= 'background-repeat:' . esc_attr($value) . ';';
                    break;
                case 'attachment':
                    $properties .= 'background-attachment:' . esc_attr($value) . ';';
                    break;
                case 'position':
                    $properties .= 'background-position:' . esc_attr($value) . ';';
                    break;
                case 'size':
                    $properties .= 'background-size:' . esc_attr($value) . ';';
                    break;
                case 'clip':
                    $properties .= 'background-clip:' . esc_attr($value) . ';';
                    break;
                case 'origin':
                    $properties .= 'background-origin:' . esc_attr($value) . ';';
                    break;
            }
            endif;
        endforeach;
    
        $output .= ($properties != '')?"\n" . esc_attr($selector) . ' { ' . $properties . '}' . "\n" : '';
    }
    return $output;
}

function investment_spacing_option( $spacing = array() ){

  if(!empty($spacing)){
      $unit = ($spacing['unit'] != '')? $spacing['unit'] : 'px';
      return (isset($spacing['top'])? $spacing['top'].$unit : 0).' '.(isset($spacing['right'])? $spacing['right'].$unit : 0).' '.(isset($spacing['bottom'])? $spacing['bottom'].$unit : 0).' '.(isset($spacing['left'])? $spacing['left'].$unit : 0);
  }else{
    return '';
  } 
  
}

function investment_get_font_family_name($value){
  $ot_set_google_fonts  = get_theme_mod( 'ot_google_fonts', array() );

  $default = array(
      'lato'     => 'Lato',
      'cardo'     => 'Cardo',
      'arial'     => 'Arial',
      'georgia'   => 'Georgia',
      'helvetica' => 'Helvetica',
      'palatino'  => 'Palatino',
      'tahoma'    => 'Tahoma',
      'times'     => '"Times New Roman", sans-serif',
      'trebuchet' => 'Trebuchet',
      'verdana'   => 'Verdana'
    );
   $default =  apply_filters( 'ot_recognized_font_families', $default );
   $default_family = !empty($default[$value])? $default[$value] : '';

  return isset($ot_set_google_fonts[$value])? $ot_set_google_fonts[$value]['family'] : $default_family;

}

function investment_typography_css($option_id, $cssvar = false, $default = array()){
    $typography = ot_get_option( $option_id, $default );    
    if(empty($typography)) return;  
    
    $css_vars = [];
    $var_prefix = str_replace('_', '-', $option_id).'-';

    $css = [];            
    foreach ($typography as $key => $value):
      if( empty($value) ) continue;

      if( $key == 'font-color' ){ 
       $key = 'color';
      }
      if( $key == 'font-family' ){
          $value = investment_get_font_family_name($value);          
      } 
      $css[] = $key. ': '.$value.'; ';
      $css_vars[$key] = "--{$var_prefix}{$key}: {$value};";       
    endforeach;  

    if($cssvar){
      return implode("\n", $css_vars);
    }
    

    return implode("\n", $css);
}

/**
 * Returns CSS for the color schemes.
 *
 * @param array $colors Color scheme colors.
 * @return string Color scheme CSS.
 */
function investment_get_dynamic_header_css() {
  $primary_color = ot_get_option( 'primary_color', '#f3525a' );
  $secondary_color = ot_get_option( 'secondary_color', '#20304f' );
  $secondary_color_light = ot_get_option( 'secondary_color_light', '#2a4068' );
  $dark_color = ot_get_option( 'dark_color', '#162440' );
  $primary_font = ot_get_option('primary_font');
  $secondary_font = ot_get_option('secondary_font');
  
  $primary_font_family = !empty($primary_font['font-family'])? '--font-family-base: '.investment_get_font_family_name($primary_font['font-family']).';' : '';
  $heading_font_family = !empty($secondary_font['font-family'])? '--headings-font-family: '.investment_get_font_family_name($secondary_font['font-family']).';' : '';

	$css = ':root{
    --primary: '.$primary_color.';
    --primary-darken: '.investment_color_luminance($primary_color, 0.2).';
    --secondary: '.$secondary_color.';
    --secondary-light: '.$secondary_color_light.';
    --dark: '.$dark_color.';
    --primary-rgb: '.investment_hex2rgb($primary_color, false).';
    --secondary-rgb: '.investment_hex2rgb($secondary_color, false).';
    --secondary-light-rgb: '.investment_hex2rgb($secondary_color_light, false).';
    --dark-rgb: '.investment_hex2rgb($dark_color, false).';
    '.$primary_font_family.$heading_font_family. 
    investment_typography_css('body', true).
    investment_typography_css('headings', true, ['font-color' => '#23272b']).
    investment_typography_css('footer', true, ['font-color' => '#23272b']).'
    --navbar-light-color: var(--dark);
    '.investment_header_bg_style().'
  }
  .btn-secondary:hover,
  .btn-secondary:focus,
  .btn-outline-primary:hover,
  .btn-outline-primary:focus{
    background-color: var(--primary);
    border-color: var(--primary);
    color: #fff;
  } 

  .btn-primary:hover,
  .btn-primary:focus,  
  .btn-outline-secondary:hover,
  .btn-outline-secondary:focus{
    background-color: var(--secondary);
    border-color: var(--secondary);
    color: #fff;
  }

  ';
  $social_icons_sticky_menu = ot_get_option( 'header_social_icons_display_in_menu', 'off' );
  if( $social_icons_sticky_menu == 'on' ){
     $css .= '.is-sticky li.social-icon{display: inline-block}';
  }
  $css .= ".bg-secondary-light {
    --bg-opacity: 1;
    background-color: rgba(var(--secondary-light-rgb), var(--bg-opacity)) !important;
  }";
	
	if( is_page() ){
		$header_image = get_post_meta( get_the_ID(), 'header_image', true );
		if( $header_image != '' ){
			$css .= ".header-banner-wrap{ background-image: url($header_image) }";
		}
	}

  $css .= investment_background_css('body_background', 'body, .boxed.custom_image').
  investment_background_css('main_container_background', '.page-wrapper').  
  '
  .boxed.pattern{
      background-image:url('.INVESTMENT_URI.'/assets/images/patterns/'.(ot_get_option('pattern', 1)).'.png);
  }';


  // logo_dimension
  $css .= '.navbar-brand{';
    $logo_height = ot_get_option('logo_height', array());
    $css .= !empty($logo_height[0])? '--navbar-brand-img-max-height: '.implode('', $logo_height).';' : '';

    
    $logo_dimension = ot_get_option('logo_dimension', array());
    $logo_dimension_unit = !empty($logo_dimension['unit'])? $logo_dimension['unit'] : 'px';
    if(!empty($logo_dimension)):      
      $css .= !empty($logo_dimension['width'])? '--navbar-brand-img-width-lg: '.$logo_dimension['width'].$logo_dimension_unit.';' : '';
      $css .= !empty($logo_dimension['height'])? '--navbar-brand-img-height-lg: '.$logo_dimension['height'].$logo_dimension_unit.';' : '';
    endif;
    

    // logo dimension for tablet
    $logo_dimension = ot_get_option('logo_dimension_md', array());
    $logo_dimension_unit = !empty($logo_dimension['unit'])? $logo_dimension['unit'] : $logo_dimension_unit;
    if(!empty($logo_dimension)):      
      $css .= !empty($logo_dimension['width'])? '--navbar-brand-img-width-md: '.$logo_dimension['width'].$logo_dimension_unit.';' : '';
      $css .= !empty($logo_dimension['height'])? '--navbar-brand-img-height-md: '.$logo_dimension['height'].$logo_dimension_unit.';' : '';
    endif;

    // logo dimension for mobile
    $logo_dimension = ot_get_option('logo_dimension_sm', array());
    $logo_dimension_unit = !empty($logo_dimension['unit'])? $logo_dimension['unit'] : $logo_dimension_unit;
    if(!empty($logo_dimension)):      
      $css .= !empty($logo_dimension['width'])? '--navbar-brand-img-width-sm: '.$logo_dimension['width'].$logo_dimension_unit.';' : '';
      $css .= !empty($logo_dimension['height'])? '--navbar-brand-img-height-sm: '.$logo_dimension['height'].$logo_dimension_unit.';' : '';
    endif;

  $css .= '}';

    

  
  



  /* primary color #f3525a*/
  $css .= '
  .product-quantity,
.footer .input-group-btn:hover:before,  
.footer .input-group-btn:focus:before,  
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:hover,
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:focus,
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item > a.mega-menu-link:hover,
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item > a.mega-menu-link:focus,  
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item > a.mega-menu-link:active,
  .transparent-header .navbar-sticky-off .cssmenu ul > li > a:hover,
.transparent-header .navbar-sticky-off .cssmenu ul > li > a:focus,
  .subscription-toggle,
  #language_list .caret,
  #language_list .dropdown-menu a:hover,
#language_list .dropdown-menu a:focus, 
  .item-content h3 a:hover,
  .item-content h3 a:focus,
  .woocommerce-Reviews-title span,
  .woocommerce-info a,
  .woocommerce div.product .woocommerce-tabs ul.tabs li.active a,
  .amount,
  .transparent-header .sticky-wrapper:not(.is-sticky) .cssmenu .menu > li > a:hover,
  .transparent-header .sticky-wrapper:not(.is-sticky) .cssmenu .menu > li > a:focus,
  .breadcrumbs a:hover,
 .breadcrumbs a:focus,
 .widget.social-icons a:hover,
 .widget.social-icons a:focus,
.footer-widget.social-icons a:hover,
.footer-widget.social-icons a:focus,
 .useful-links li a:before,
 .post h6 a:hover,
 .post h6 a:focus,
.post-title a:hover,
.post-title a:focus,
#main .post-meta .primary-color a,
.primary-color,
.nav-tabs > li.active > a,
#main .post-meta span.icon,
#main .post-text .block-quote,
.about_author .content i,
.block-comments .comment .comment-meta .reply,
#sidebar .post .date span,
#sidebar .testimonial span.h_small,
#sidebar .brochures .caps_normal .fa,
.submission_requirments p a,
.year_list label,
.year_list span,
.testimonial-area .testimonial .content span,
.single-team-member .caps_small,
.social-link a,
.team-member-contact-info .contact-info li i,
.protfolio-single #main span.normal,
#sidebar ul.menu-sidebar li a:hover,
#sidebar ul.menu-sidebar li a:focus,
.widget ul li a:hover,
.widget ul li a:focus,
.news-letter2 .input-group-btn .btn-default i,
.home-banner.home-banner-col3 .square-menu ul li span i,
.icon-bg-no i,
.testimonial .h_small{
  color: var(--primary);
}
  ';

  $css .= '
  #mega-menu-wrap-primary #mega-menu-primary li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu:before,
  .owl-theme .owl-dots .owl-dot.active span, 
  .owl-theme .owl-dots .owl-dot:hover span,
.submit,
  .dropdown-menu:before,
.square-primary,
.tagcloud a:hover,
.tagcloud a:focus,
#sidebar .tags a:hover,
#sidebar .tags a:focus,
header .menu li:after,
header .menu > current-menu-parent:after,
.post-pagination ul li a.active,
.post-pagination ul li a:hover,
.post-pagination ul li a:focus,
.underline-primary:after,
.underline_bold:after,
.underline_small:after,
.border-title::after,
.square-menu ul li:hover > div,
.square-menu ul li:focus > div,
.square-menu-wrap .square-menu figure:hover figcaption,
.square-menu-wrap .square-menu .csshover figure figcaption,
.square-menu-wrap.service-style1 .square-menu figure:hover .figure-block,
.square-menu-wrap.service-style1 .square-menu .csshover figure .figure-block,
.year_list span,
.education-training ul li span::after,
.area-of-expertise ul li span::after,
.protfolio-single #main span.normal::after,
.dark-primary-bg,
.btn-primary-outline:hover,
.btn-primary-outline:focus,
.career .figures-block .invested,
.page-wrapper-green .about-section .ewt,
.investment-tabs .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tabs-list .vc_tta-tab.vc_active > a span::before,
.help-center,
.help.secondary-bg a,
body .help a.button:not(.btn-primary-outline):hover,
body .help a.button:not(.btn-primary-outline):focus,
header .menu > li.topbar-button.active > a,
.return-to-shop .button{
  background-color: var(--primary);
}';

$css .= '.help.secondary-bg a{
  border-color: var(--primary);
}';

$css .= '
.primary-bg.top-arrow-yes:before{
  border-color: transparent  transparent var(--primary) transparent ;
}
.primary-bg.bottom-arrow-yes:after{
  border-color: var(--primary) transparent  transparent transparent;
}
';

$inner_offset = ot_get_option('inner_padding', array( '30',  'px' ));
$inner_offset = isset($inner_offset[0]) ? $inner_offset[0] : '0';

$container = ot_get_option( 'container_width', array( '1170',  'px' ) );
$container_unit = !empty($container[1])? $container[1] : 'px';
if(!empty($container[0])):
  $container_width = intval($container[0]) + intval($inner_offset);
  $css .= '@media (min-width: 1200px) { 
    .container {  max-width: '.esc_attr($container[0]).esc_attr($container_unit).'; }
    .boxed .page-wrapper {  max-width: '.$container_width.esc_attr($container_unit).'; }
  }';
endif;

$container = ot_get_option( 'container_width_lg', array( '1320',  'px' ) );
if(!empty($container[0])):
  $container_width = intval($container[0]) + intval($inner_offset);
  $container_unit = !empty($container[1])? $container[1] : $container_unit;
  $css .= '@media (min-width: 1400px){
    .container {  max-width: '.intval($container[0]).$container_unit.';}
    .boxed .page-wrapper {  max-width: '.$container_width.$container_unit.'; } 
  }'; 
endif;



$css .= '.boxed{
    padding-top: '.implode('', ot_get_option( 'top_padding', array( '0',  'px' ) )).';
    padding-bottom: '.implode('', ot_get_option( 'bottom_padding', array( '0',  'px' ) )).';
}

.boxed .page-wrapper{
    padding: '.investment_spacing_option(ot_get_option( 'main_container_spacing', array())).';
}';
 $css .= investment_background_css('main_container_background', '.boxed .page-wrapper' );
 $css .= investment_border_css('main_container_border', '.boxed .page-wrapper' );

$css .= '
.invenstment-button,
.investment-separator{
  background-color: '.$primary_color.' !important;
}
.investment-risk-reward-profile ul li.reward-active{ background-color: var(--primary); }
.investment-risk-reward-profile ul li.reward-active:before{ border-bottom-color: var(--primary); }
.investment-risk-reward-profile ul li.reward-active:after{ border-top-color: var(--primary); }
';

  $css .= '
  header .menu > li.topbar-button.active > a,
  .block-quote,
.post-pagination ul li a,
.nav-tabs > li.active,
.quote-text blockquote,
blockquote,
.service-single .post-text .block-quote,
.expertise-icon,
.btn-primary-outline,
#sidebar ul.menu > li.active, 
#sidebar ul.menu > li:hover,
#sidebar ul.menu-sidebar > li.active, 
#sidebar ul.menu-sidebar > li:hover,
.widget > ul > li.active, 
.widget > ul > li:hover,
.panel-heading,
#main .post-text .block-quote,
.primary-header .dropdown-menu,
.investment-accordions .vc_tta.vc_general .vc_tta-panel-title > a
{
  border-color: var(--primary);
}';

$css .= '.border:after {
    border-color: transparent transparent var(--primary);
}
.rtl #sidebar ul.menu > li.active, 
.rtl #sidebar ul.menu > li:hover, 
.rtl #sidebar ul.menu-sidebar > li.active, 
.rtl #sidebar ul.menu-sidebar > li:hover, 
.rtl .widget > ul > li.active, 
.rtl .widget > ul > li:hover,
.rtl .investment-accordions .vc_tta.vc_general .vc_tta-panel-title > a {
    border-right-color: var(--primary);
}
.overlay.primary-overlay,
.overlay.primary-overlay .vc_parallax-inner{
  box-shadow: 0px 1000px rgba(var(--primary-rgb), .6) inset;
}'
;
/* Secondary color #20304f */

$css .= '
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link,
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item.mega-toggle-on > a.mega-menu-link,
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item > a.mega-menu-link,
.price ins,
h3,
h2.product_title,
.star-rating span,
h3.color_blue,
.color_blue, .color_blue a,
.color-gray a,
.case-studies-portfolio .options .filters li a,
.secondary-color-dark,
.post h6 a,
.content-block .button:hover i,
.content-block .button:focus i,
.block-content .button:hover i,
.block-content .button:focus i,
.btn-green-outline,
.experienced-team .block-content h2,
.experienced-team .block-content .btn-primary-outline,
.news .content-block h2,
.news .content-block .btn-primary-outline,
#sidebar .icon.icon-Search,
#sidebar ul.menu-sidebar li a,
.widget ul li a,
 .company-overview h2.underline-primary,
 .our-partners .block-content .btn-primary-outline,
 .tab-content .name,
 .insides .normal,
 .increase-rofitability-text h4,
 .map-tab-area ul li a,
 .our-clients h2,
 .nav-tabs > li > a ,
 .list-item h4 ,
 .testimonial-style1 h4,
 .news .post h4,
 .small-h4, 
#sidebar .small-h4,
.get-touch h4,
.working-houre h4,
.single-team-member h4,
#sidebar .brochures .caps_normal.primary-bg .fa,
.primary-bg .contact-block i{
  color: var(--secondary);
}
';
  
$css .= '


.submit:hover,
.submit:focus,
.expertise-icon,
.help a,
#sidebar .brochures,
.price_slider_amount .button,
.bg_dark_blue,
.dropcap,
header .menu .topbar-button .btn-primary:hover,
header .menu .topbar-button .btn-primary:focus,
.is-sticky .navbar.secondary-bg-dark,
.header-banner-wrap,
.secondary-bg-dark,
.secondary-bg-dark,

.footer,

#main .conclusion .normal span,
.btn-primary:hover,
.btn-primary:focus,
body .help.secondary-bg a.button:not(.btn-primary-outline):hover,
body .help.secondary-bg a.button:not(.btn-primary-outline):focus,
.options .filters li a.active,
.case-studies-portfolio .options .filters li a.active{
  background-color: var(--secondary);
}';

$css .= '
.invenstment-button:hover,
.invenstment-button:focus{
  background-color: var(--secondary) !important;
} 
';
$css .= '
.secondary-bg-dark.top-arrow-yes:before{
  border-color: transparent  transparent var(--secondary) transparent ;
}
.secondary-bg-dark.bottom-arrow-yes:after{
  border-color: var(--secondary) transparent  transparent transparent;
}
';
$css .= '
.overlay.secondary-overlay,
.overlay.secondary-overlay .vc_parallax-inner{
  box-shadow: 0px 1000px rgba(var(--secondary-rgb), .6) inset;
}
';

  $css .= '
  body .help.primary-bg a.button:not(.btn-primary-outline):hover,
body .help.primary-bg a.button:not(.btn-primary-outline):focus,
.toggle-button .menu-button,
.job-location,
.btn-secondary-outline{
  border-color: var(--secondary);
}';

$css .= '
.secondary-light-bg,
.download_wrap .button:hover,
.download_wrap .button:focus,
.portfolio-template .info-block .info-block-inner,
.options{
  background-color: '.$secondary_color_light.';
}';



$css .= '
.apply-job .btn-primary:hover,.apply-job .btn-primary:focus,
.grid,
.dark-bg,
.secondary-dark-bg,
.news-letter2 .form-control,
.news-letter2 .input-group-btn,
.news-letter2 .input-group-btn .btn-default,
.copyright{
  background-color: var(--dark);
 }

';
$css .= investment_background_css('footer_background', '.footer');
$css .= investment_background_css('footer_copyright_background', '.copyright-bar');
$css .= 'body{
   '.investment_typography_css('primary_font').'
}
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item > a.mega-menu-link,
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link,
.h_small,
h1,
h2,
h3,
h4,
h5,
h6,
ul.menu,
.insides .normal,
.workpage .h_small,
.post-title,
.block-comments .comment .comment-meta .reply,
.get-in-touch li,
#sidebar ul.menu-sidebar li a,
.widget ul li a,
.panel > a,
.tab-content .name,
.figures-block .big-title,
.vc_tta.vc_general .vc_tta-tab a{
    '.investment_typography_css('secondary_font').'
}        
body{
  '.investment_typography_css('body').'
}
.navbar-nav .nav-link{
    '.investment_typography_css('menu_a').'
}
.navbar-nav .dropdown-item{
    '.investment_typography_css('submenu_a').'
}
h1.underline_small,
h1.underline_bold,
h1{
  '.investment_typography_css('h1').'
}
h2.underline_small,
h2.underline_bold,
h2{
'.investment_typography_css('h2').'
}
h3.underline_small,
h3.underline_bold,
h3{
'.investment_typography_css('h3').'
}
h4.underline_small,
h4.underline_bold,
h4{
'.investment_typography_css('h4').'
}
h5.underline_small,
h5.underline_bold,
h5{
'.investment_typography_css('h5').'
}
h6.underline_small,
h6.underline_bold,
h6{
'.investment_typography_css('h6').'
}
.small-h4, #sidebar .small-h4{
    '.investment_typography_css('sidebar_title').'
}
.footer{
  '.investment_typography_css('footer').'
}
';

if(in_array('yes', ot_get_option('disable_button_icon', ['no']))){
  $css .= '.btn .icon-arrows-slim-right{
    display: none;
  }';

  $css .= '.news-letter .btn .icon-arrows-slim-right{
    display: inline-block;
  }';
}

if(ot_get_option('header_style', 'header-style1') == 'header-style2'){
  $css .= 'body:not(.frontpage-transparent-header) .header-wrapper {
    height: 160px !important;
  }';
}

	return investment_compress($css);
}

/**
 * Output an Underscore template for generating CSS for the color scheme.
 *
 * The template generates the css dynamically for instant display in the Customizer
 * preview.
 *
 */
function investment_color_scheme_css() {	
	wp_add_inline_style( 'investment-styles', investment_get_dynamic_header_css() );
}
add_action( 'wp_enqueue_scripts', 'investment_color_scheme_css' );
