<?php
include get_template_directory() . '/includes/scripts.php';
include get_template_directory() . '/includes/dynamic-style.php';


if (function_exists('is_woocommerce')) {
    include get_template_directory() . '/includes/woo-functions.php';
}

if (!function_exists('investment_comment_nav')) :

    /**
     * Display navigation to next/previous comments when applicable.
     */
    function investment_comment_nav() {
        // Are there comments to navigate through?
        if (get_comment_pages_count() > 1 && get_option('page_comments')) :
            ?>
            <nav class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php _e('Comment navigation', 'investment'); ?></h2>
                <div class="nav-links">
                    <?php
                    if ($prev_link = get_previous_comments_link(__('Older Comments', 'investment'))) :
                        printf('<div class="nav-previous">%s</div>', $prev_link);
                    endif;

                    if ($next_link = get_next_comments_link(__('Newer Comments', 'investment'))) :
                        printf('<div class="nav-next">%s</div>', $next_link);
                    endif;
                    ?>
                </div><!-- .nav-links -->
            </nav><!-- .comment-navigation -->
            <?php
        endif;
    }

endif;

if (!function_exists('investment_comment_callback')):

    function investment_comment_callback($comment, $args, $depth) {
        if ('div' === $args['style']) {
            $tag = 'div';
            $add_below = 'comment';
        } else {
            $tag = 'li';
            $add_below = 'div-comment';
        }
        ?>
        <<?php echo esc_attr($tag) ?> <?php comment_class(empty($args['has_children']) ? 'clearfix' : 'parent clearfix') ?> id="comment-<?php comment_ID() ?>">
        <div id="div-comment-<?php comment_ID() ?>" class="comment-info comment-body">



                <?php if ($args['avatar_size'] != 0) echo get_avatar($comment, $args['avatar_size']); ?>

            <div class="content pb-30">
                            <?php printf(__('<h6 class="comment-authore"><strong class="fn">%s</strong></h6>', 'investment'), get_comment_author_link()); ?>
                <div class="comment-meta">					
                    <span class="caps_small date"><a href="<?php echo htmlspecialchars(get_comment_link($comment->comment_ID)); ?>">

        <?php
        /* translators: 1: date, 2: time */
        printf(__('%1$s at %2$s', 'investment'), get_comment_date(), get_comment_time());
        ?></a> / 
                    </span>
                    </span><?php echo investment_comment_reply_link(array_merge($args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                </div>


        <?php if ($comment->comment_approved == '0') : ?>
                    <em class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.', 'investment'); ?></em>
                    <br />
        <?php endif; ?>

                <div class="comment-body"><?php comment_text(); ?></div>
        <?php edit_comment_link(__('(Edit)', 'investment'), '  ', ''); ?>

            </div><!-- .content -->
        </div><!-- .comment-info -->
        <?php
    }

endif;

add_filter('next_posts_link_attributes', 'investment_next_posts_link_attributes');

function investment_next_posts_link_attributes() {
    return 'class="btn btn-outline-primary float-right"';
}

add_filter('previous_posts_link_attributes', 'investment_previous_posts_link_attributes');

function investment_previous_posts_link_attributes() {
    return 'class="btn btn-outline-primary newer-posts"';
}

if (!function_exists('investment_posts_navigation')):

    function investment_posts_navigation($numeric = false) {
        if ($numeric) {
            if (is_singular())
                return;

            global $wp_query;

            /** Stop execution if there's only 1 page */
            if ($wp_query->max_num_pages <= 1)
                return;

            $paged = get_query_var('paged') ? absint(get_query_var('paged')) : 1;
            $max = intval($wp_query->max_num_pages);

            /** 	Add current page to the array */
            if ($paged >= 1)
                $links[] = $paged;

            /** 	Add the pages around the current page to the array */
            if ($paged >= 3) {
                $links[] = $paged - 1;
                $links[] = $paged - 2;
            }

            if (( $paged + 2 ) <= $max) {
                $links[] = $paged + 2;
                $links[] = $paged + 1;
            }

            echo '<div class="post-pagination"><ul class="list-inline">';

            /** 	Previous Post Link */
            if (get_previous_posts_link())
                printf('<li class="list-inline-item"><a href="%s"><i class="icon-arrows-slim-right rotate"></i></a></li></li>', esc_url(get_pagenum_link(1)));

            /** 	Link to first page, plus ellipses if necessary */
            if (!in_array(1, $links)) {
                $class = 1 == $paged ? ' class="active"' : '';

                printf('<li class="list-inline-item"><a%s href="%s">%s</a></li>', $class, esc_url(get_pagenum_link(1)), '1');

                if (!in_array(2, $links))
                    echo '<li class="list-inline-item">...</li>';
            }

            /** 	Link to current page, plus 2 pages in either direction if necessary */
            sort($links);
            foreach ((array) $links as $link) {
                $class = $paged == $link ? ' class="active"' : '';
                printf('<li class="list-inline-item"><a%s href="%s">%s</a></li>', $class, esc_url(get_pagenum_link($link)), $link);
            }

            /** 	Link to last page, plus ellipses if necessary */
            if (!in_array($max, $links)) {
                if (!in_array($max - 1, $links))
                    echo '<li class="list-inline-item">…</li>';

                $class = $paged == $max ? ' class="active"' : '';
                printf('<li class="list-inline-item"><a%s href="%s">%s</a></li>', $class, esc_url(get_pagenum_link($max)), $max);
            }

            /** 	Next Post Link */
            if (get_next_posts_link())
                printf('<li class="list-inline-item"><a href="%s"><i class="icon-arrows-slim-right"></i></a></li>', esc_url(get_pagenum_link($max)));

            echo '</ul></div>' . "\n";
        } else {
            echo '<div class="posts-navigation">';
            echo get_previous_posts_link('<i class="icon-arrows-slim-right"></i>' . esc_attr(__('Newer Posts', 'investment')));
            echo get_next_posts_link(__('Older Posts', 'investment') . '<i class="icon-arrows-slim-right"></i>');
            echo '</div>';
        }
    }

endif;

if (!function_exists('investment_post_navigation')):

    function investment_post_navigation() {
        if (is_singular('attachment')) {
            // Parent post navigation.
            the_post_navigation(array(
                'prev_text' => _x('<span class="meta-nav">Published in</span><span class="post-title">%title</span>', 'Parent post link', 'investment'),
            ));
        } elseif (is_singular(array('post', 'portfolio'))) {
            // Previous/next post navigation.
            the_post_navigation(array(
                'next_text' => '<span class="meta-nav" aria-hidden="true">' . sprintf(_x('%s', 'Next post text', 'investment'), ot_get_option('next_post_text', 'Next')) . '</span> ' .
                '<span class="screen-reader-text">' . __('Next post:', 'investment') . '</span> ' .
                '<h6>%title</h6>',
                'prev_text' => '<span class="meta-nav" aria-hidden="true">' . sprintf(_x('%s', 'Previous post text', 'investment'), ot_get_option('prev_post_text', 'Previous')) . '</span> ' .
                '<span class="screen-reader-text">' . __('Previous post:', 'investment') . '</span> ' .
                '<h6>%title</h6>',
            ));
        }
    }

endif;

if (!( function_exists('investment_template_pagination') )):

    function investment_template_pagination($pages = '', $range = 2, $number = true) {
        $showitems = ($range * 2) + 1;
        global $wp_query;
        $paged = (isset($wp_query->query['paged'])) ? $wp_query->query['paged'] : 1;

        if ($pages == '') {

            $pages = $query->max_num_pages;
            if (!$pages) {
                $pages = 1;
            }
        }
        $older_posts_text = ot_get_option('older_posts_text', 'Older Posts');
        $newer_posts_text = ot_get_option('newer_posts_text', 'Newer Posts');

        $output = '';

        if ((1 != $pages) && (!$number)) {
            $output .= "<div class='text-center'><ul class='pagination list-inline'>";
            if ($paged > 2 && $paged > $range + 1 && $showitems < $pages)
                $output .= "<li><a href='" . get_pagenum_link(1) . "' aria-label='Previous'><span aria-hidden='true'>&laquo;</span></a></li> ";

            for ($i = 1; $i <= $pages; $i++) {
                if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems )) {
                    $output .= ($paged == $i) ? "<li class='active'><a href='" . get_pagenum_link($i) . "'>" . $i . "</a></li> " : "<li><a href='" . get_pagenum_link($i) . "'>" . $i . "</a></li> ";
                }
            }

            if ($paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages)
                $output .= "<li><a href='" . get_pagenum_link($pages) . "' aria-label='Next'><span aria-hidden='true'>&raquo;</span></a></li> ";
            $output .= "</ul></div>";
        } else {
            $older_posts_text = sprintf(_x('%s', 'Older post text', 'investment'), $older_posts_text);
            $newer_posts_text = sprintf(_x('%s', 'Newer post text', 'investment'), $newer_posts_text);

            $output .= '<div class="posts-navigation">';
            $output .= ($paged > 1) ? '<a href="' . get_pagenum_link($paged - 1) . '" class="btn btn-default newer-posts"><i class="fa fa-angle-left"></i>' . esc_attr($newer_posts_text) . '</a>' : '';
            $output .= ($pages != $paged) ? '<a href="' . get_pagenum_link($paged + 1) . '" class="btn btn-default older-posts pull-right">' . esc_attr($older_posts_text) . '<i class="fa fa-angle-right"></i></a>' : '';
            $output .= '</div>';
        }


        return $output;
    }

endif;

if (!function_exists('investment_post_category')) :

    function investment_post_category() {
        global $post;
        $categories_list = get_the_category_list(_x(', ', 'Used between list items, there is a space after the comma.', 'investment'), '', $post->ID);
        if ($categories_list) {
            printf('%1$s',
                    $categories_list
            );
        }
    }

endif;

if (!function_exists('investment_sticky_post_text')) :

    function investment_sticky_post_text() {
        global $post;
        if (is_sticky()) {
            $sticky = ot_get_option('sticky_post_text', 'Sticky');
            printf(_x('<span class="sticky-post primary-bg">%s</span>', 'Sticky post text with seperator icon', 'investment'), $sticky);
        }
    }

endif;

if (!function_exists('investment_entry_meta')) :

    /**
     * Prints HTML with meta information for the categories, tags.
     */
    function investment_entry_meta() {
        global $post;

        $post_meta_display = ot_get_option('post_meta_display', 'on');
        if ($post_meta_display == 'off')
            return false;

        $disable_meta = ot_get_option('disable_post_meta', array());

        echo '<div class="post-meta my-20 pt-20">';

        if (in_array(get_post_type(), array('post', 'attachment')) && !in_array('date', $disable_meta)) {

            $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

            $time_string = sprintf($time_string,
                    esc_attr(get_the_date('c')),
                    get_the_date('l, M d, Y')
            );

            printf('<a class="date caps_normal" href="%1$s" rel="bookmark"><i class="primary-color perch-Keyboard"></i>%2$s</a>',
                    esc_url(get_permalink()),
                    $time_string
            );
        }

        if ('post' == get_post_type() && !in_array('user', $disable_meta)) {
            printf('<a class="by caps_normal url fn n" href="%2$s"><i class="primary-color perch-User"></i> %1$s <span class="byline"><span class="author vcard primary-color">%3$s</span></span></a>',
                    _x('by:', 'Used before post author name.', 'investment'),
                    esc_url(get_author_posts_url(get_the_author_meta('ID'))),
                    get_the_author()
            );
        }


        if (in_array(get_post_type(), array('post', 'attachment')) && !in_array('category', $disable_meta)) {
            $categories_list = get_the_category_list(_x(', ', 'Used between list items, there is a space after the comma.', 'investment'), '', $post->ID);
            if ($categories_list) {
                printf('<span class="posted-in caps_normal"><i class="primary-color perch-Folder"></i>%1$s <span class="primary-color">%2$s</span></span>',
                        _x('posted in:', 'Used before post category name.', 'investment'),
                        $categories_list
                );
            }
        }

        if (in_array(get_post_type(), array('post', 'attachment')) && !in_array('comment', $disable_meta)) {

            printf('<a href="%3$s" class="comments caps_normal">
            <i class="primary-color perch-Message"></i>%1$s  <span class="primary-color">%2$s</span>
          </a>',
                    _x('comments:', 'Used before post comments.', 'investment'),
                    get_comments_number($post->ID),
                    get_permalink($post->ID)
            );
        }






        echo '</div>';
    }

endif;

function investment_date_meta() {
    echo '<span class="post-meta">';

    if (in_array(get_post_type(), array('post', 'attachment'))) {

        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

        $time_string = sprintf($time_string,
                esc_attr(get_the_date('c')),
                get_the_date('M d, Y')
        );

        printf('%1$s <a href="%2$s" rel="bookmark">%3$s</a>',
                __('Posted On :', 'investment'),
                esc_url(get_permalink()),
                $time_string
        );
    }

    echo '</span>';
}

if (!function_exists('investment_footer_entry_meta')) :

    /**
     * Prints HTML with meta information for the categories, tags.
     */
    function investment_footer_entry_meta() {
        global $post;
        echo '<div class="share">';

        if ((is_single() && ('post' == get_post_type()))) {
            echo get_the_tag_list('<div class="tagcloud pull-left">', '', '</div>');
        }

        if ((is_single() && ('portfolio' == get_post_type()))) {
            echo get_the_term_list($post->ID, 'portfolio_tag', '<div class="tagcloud pull-left">', '', '</div>');
        }


        if (is_single()) {
            $sharing = ot_get_option('single_post_sharing', 'on');
        } else {
            $sharing = ot_get_option('archive_post_sharing', 'on');
        }

        if (class_exists('ESSB_Manager') && ($sharing == 'on')) {
            $url = get_permalink($post->ID);
            $title = get_the_title($post->ID);
            echo '<div class="pull-right essb-shortcode">';
            echo '<span class="share-text">' . esc_attr(__('Share:', 'investment')) . '</span>';
            echo do_shortcode('[easy-social-share morebutton="1" counters=0 style="icon" template="metro-retina" fixedwidth_align="right"  text="Share: "]');
            echo '</div>';
        }


        echo '</div>';
    }

endif;

if (!function_exists('investment_excerpt_length')) :

//excerpt length	
    function investment_excerpt_length($length) {
        return ot_get_option('excerpt_length', 35);
    }

    add_filter('excerpt_length', 'investment_excerpt_length', 999);
endif;

if (!function_exists('investment_excerpt_more') && !is_admin()) :

    /**
     * Replaces "[...]" (appended to automatically generated excerpts) with ... and a 'Continue reading' link.
     */
    function investment_excerpt_more($more) {
        global $posts;
        $readmore_text = ot_get_option('read_more_text', 'Read More');
        return '<div class="read-more-wrap"><a href="' . get_permalink() . '" class="btn btn-secondary">' . esc_attr($readmore_text) . ' <i class="icon-arrows-slim-right"></i></a></div>';
    }

    add_filter('excerpt_more', 'investment_excerpt_more');
    add_filter('the_content_more_link', 'investment_excerpt_more');
endif;

if (!function_exists('investment_get_trim_words') && !is_admin()) :

    function investment_get_trim_words($content = '', $count = 25, $ext = '', $btn = true, $btnclass = "btn btn-secondary", $btntext = '') {
        global $post;
        if ($content == '')
            $content = get_the_excerpt($post->ID);

        $output = '<p class="normal">' . wp_trim_words($content, $count, $ext) . '</p>';
        if ($btn) {
            $readmore_text = ot_get_option('read_more_text', 'Read More');
            $readmore_text = ($btntext == '') ? $readmore_text : $btntext;

            $output .= '<a class="btn ' . esc_attr($btnclass) . '" href="' . get_permalink($post->ID) . '">' .
                    sprintf(_x('%s', 'Continue Reading text', 'investment'), esc_attr($readmore_text)) . '<i class="icon icon-arrows-slim-right"></i></a>';
        }

        return $output;
    }

endif;

//add_filter('get_the_excerpt', 'investment_get_the_excerpt', 10, 2);
function investment_get_the_excerpt($excerpt, $post) {

    $output = '';
    $readmore_text = ot_get_option('read_more_text', 'Read More');

    $output .= '<a class="btn btn-secondary" href="' . get_permalink($post->ID) . '">' .
            sprintf(_x('%s', 'Continue Reading text', 'investment'), esc_attr($readmore_text)) . ' <i class="icon icon-arrows-slim-right"></i></a>';

    return '<p class="normal">' . $excerpt . '</p>' . $output;
}

/* Layout option for investment */

function investment_layout_option_values($options = array()) {
    global $wpdb;

    if (is_page()):
        $layout = get_post_meta(get_the_ID(), 'page_layout', true);

        $sidebar = get_post_meta(get_the_ID(), 'sidebar', true);
        $sidebar = ( $sidebar == '' ) ? 'sidebar-1' : $sidebar;
    elseif (is_single()):
        $layout = ot_get_option('single_layout', 'rs');
        $sidebar = ot_get_option('single_layout_sidebar', 'sidebar-1');
    else:
        $layout = ot_get_option('blog_layout', 'rs');
        $sidebar = ot_get_option('blog_layout_sidebar', 'sidebar-1');
    endif;

    if (function_exists('is_woocommerce')) {
        if (is_product()):
            $layout = ot_get_option('product_layout', 'full');
            $sidebar = ot_get_option('product_layout_sidebar', 'sidebar-3');
        elseif (is_woocommerce()):
            $layout = ot_get_option('shop_layout', 'ls');
            $sidebar = ot_get_option('shop_layout_sidebar', 'sidebar-2');
        endif;
    }

    if ('portfolio' == get_post_type()) {

        $layout = ot_get_option('portfolio_layout', 'full');
        $sidebar = ot_get_option('portfolio_layout_sidebar', 'sidebar-portfolio');

        if (is_singular('portfolio')) {
            $layout = ot_get_option('portfolio_single_layout', 'rs');
            $sidebar = ot_get_option('portfolio_single_layout_sidebar', 'sidebar-portfolio');
        }
    }

    if ('service' == get_post_type()) {

        if (get_post_status(get_option('service_archive_id')) == 'publish') {
            $page_id = get_option('service_archive_id');
            $layout = get_post_meta($page_id, 'page_layout', true);
            $sidebar = get_post_meta($page_id, 'sidebar', true);
        } else {
            $layout = ot_get_option('services_layout', 'rs');
            $sidebar = ot_get_option('services_layout_sidebar', 'sidebar-1');
        }

        if (is_singular('service')) {
            $layout = ot_get_option('services_single_layout', 'rs');
            $sidebar = ot_get_option('services_single_layout_sidebar', 'sidebar-service');
        }
    }

    if ('team' == get_post_type()) {

        if (get_post_status(get_option('team_archive_id')) == 'publish') {
            $page_id = get_option('team_archive_id');
            $layout = get_post_meta($page_id, 'page_layout', true);
            $sidebar = get_post_meta($page_id, 'sidebar', true);
        } else {
            $layout = ot_get_option('teams_layout', 'rs');
            $sidebar = ot_get_option('teams_layout_sidebar', 'sidebar-1');
        }

        if (is_singular('team')) {
            $layout = ot_get_option('teams_single_layout', 'rs');
            $sidebar = ot_get_option('teams_single_layout_sidebar', 'sidebar-service');
        }
    }



    $layout = ( $layout == '' ) ? 'full' : $layout;

    $options['layout'] = $layout;
    $options['sidebar'] = ( $layout != 'full' ) ? $sidebar : '';

    return apply_filters('investment_layout_option_values', $options);
}

function investment_get_layout() {
    global $wpdb;
    return $wpdb->investment['layout'];
}

function investment_get_sidebar() {
    global $wpdb;
    return $wpdb->investment['sidebar'];
}

function investment_page_title_display() {
    global $post;
    $display = get_post_meta($post->ID, 'title_display', true);
    return ($display == 'off') ? false : true;
}

function investment_get_page_title() {
    global $post;
    $title = get_post_meta($post->ID, 'title', true);
    $subtitle = get_post_meta($post->ID, 'subtitle', true);

    $output = '<div class="post-info page-info text-center">
				<h3 class="post-title">' . (($title != '') ? esc_attr($title) : esc_attr(get_the_title()) ) . '</h3>'
            . (($subtitle != '') ? '<p class="subtitle">' . esc_attr($subtitle) . '</p>' : '') . '
				<div class="shape1"><i class="perch perch-cross-leaf"></i></div>
      			</div><!-- .post-info -->';
    return $output;
}

function investment_page_title() {
    echo (investment_page_title_display()) ? investment_get_page_title() : '';
}

//add layout option
function investment_body_class($classes) {
    global $wp_query, $wpdb;

    $wpdb->investment = investment_layout_option_values();
    if (!is_page_template('page-templates/one-page.php')) {
        $style = ot_get_option('background_style', 'width');
        $classes[] = $style;
        if ($style == 'boxed') {
            $classes[] = ot_get_option('background_type', 'pattern');
        }
    }

    if ($wpdb->investment['layout'] == 'ls') {
        $classes[] = 'left-sidebar';
    } elseif ($wpdb->investment['layout'] == 'rs') {
        $classes[] = 'right-sidebar';
    } else {
        $classes[] = 'no-sidebar';
    }

    if (is_page() && is_front_page()) {
        $header_style = ot_get_option('frontpage_header_style', 'transparent-header');
        $classes[] = 'frontpage-' . $header_style;
    }

    if (is_page()) {
        $force_transparent_header = get_post_meta(get_the_ID(), 'force_transparent_header', true);
        if ($force_transparent_header == 'on') {
            $classes[] = 'frontpage-transparent-header';
        }
    }

    $post_type_arr = array('portfolio', 'service', 'team', 'partner', 'job');
    foreach ($post_type_arr as $key => $value) {
        if ($value == get_post_type()) {
            if (get_post_status(get_option($value . '_archive_id')) == 'publish') {
                $page_id = get_option($value . '_archive_id');
                $force_transparent_header = get_post_meta($page_id, 'force_transparent_header', true);
                if ($force_transparent_header == 'on') {
                    $classes[] = 'frontpage-transparent-header';
                }
            }
        }
    }

    if ('post' == get_post_type()) {
        if (get_post_status(get_option('page_for_posts')) == 'publish') {
            $page_id = get_option('page_for_posts');
            $force_transparent_header = get_post_meta($page_id, 'force_transparent_header', true);
            if ($force_transparent_header == 'on') {
                $classes[] = 'frontpage-transparent-header';
            }
        }
    }

    /* if( is_page('Home') || is_page('Home 2') || is_page('Home 3') || is_page('Home video')){
      $classes[] = 'frontpage-transparent-header';
      } */


    return $classes;
}

add_filter('body_class', 'investment_body_class');

function investment_header_class($class = '') {
    // Separates classes with a single space, collates classes for body element
    echo 'class="' . join(' ', investment_get_header_class($class)) . '"';
}

function investment_get_header_class($class = '') {
    global $wp_query;

    $classes = array('header-section');
    $classes = investment_get_transparent_header_class($classes);

    //$classes[] = ot_get_option('header_style', '');



    $header_sticky_nav = ot_get_option('header_sticky_nav', 'on');
    $classes[] = 'sticky-header-' . $header_sticky_nav;

    if (!in_array('transparent-header', $classes)) {
        $header_bg = ot_get_option('header_background', 'default-bg');
        $classes[] = $header_bg == 'default-bg' ? 'bg-body' : $header_bg;
    }



    if (!empty($class)) {
        if (!is_array($class))
            $class = preg_split('#\s+#', $class);
        $classes = array_merge($classes, $class);
    } else {
        // Ensure that we always coerce class to being an array.
        $class = array();
    }

    $classes = array_map('esc_attr', $classes);

    $classes = apply_filters('investment_header_class', $classes, $class);

    return array_unique($classes);
}

function investment_get_transparent_header_class($classes) {
    if (is_front_page() && !is_home()) {
        $classes[] = ot_get_option('frontpage_header_style', 'transparent-header');
    }



    if (is_page()) {
        $force_transparent_header = get_post_meta(get_the_ID(), 'force_transparent_header', true);
        if ($force_transparent_header == 'on') {
            $classes[] = 'transparent-header';
        }
    }

    $post_type_arr = array('portfolio', 'service', 'team', 'partner', 'job');
    foreach ($post_type_arr as $key => $value) {
        if ($value == get_post_type()) {
            if (get_post_status(get_option($value . '_archive_id')) == 'publish') {
                $page_id = get_option($value . '_archive_id');
                $force_transparent_header = get_post_meta($page_id, 'force_transparent_header', true);
                if ($force_transparent_header == 'on') {
                    $classes[] = 'transparent-header';
                }
            }
        }
    }

    if ('post' == get_post_type()) {
        if (get_post_status(get_option('page_for_posts')) == 'publish') {
            $page_id = get_option('page_for_posts');
            $force_transparent_header = get_post_meta($page_id, 'force_transparent_header', true);
            if ($force_transparent_header == 'on') {
                $classes[] = 'transparent-header';
            }
        }
    }
    return $classes;
}

function investment_content_wrap_class() {
    $classes = array();
    $layout = investment_get_layout();
    $classes[] = ($layout != 'full') ? 'col-lg-9' : 'col-lg-12';
    return array_unique($classes);
}

if (!function_exists('investment_gallery_format_content')):

    function investment_gallery_format_content() {
        global $post;
        $meta_value = get_post_meta($post->ID, '_format_gallery', true);
        if ($meta_value != '')
            echo do_shortcode($meta_value);
    }

endif;

if (!function_exists('investment_video_format_content')):

    function investment_video_format_content() {
        global $post;
        $meta_value = get_post_meta($post->ID, '_format_video_embed', true);
        if ($meta_value != '') {
            $embed = new WP_Embed();
            echo '<div class="responsive-video">' . $embed->run_shortcode($meta_value) . '</div>';
        }
    }

endif;

if (!function_exists('investment_audio_format_content')):

    function investment_audio_format_content() {
        global $post;
        $meta_value = get_post_meta($post->ID, '_format_audio_embed', true);
        if ($meta_value != '') {
            $embed = new WP_Embed();
            echo '<div class="audio-holder">' . $embed->run_shortcode($meta_value) . '</div>';
        }
    }

endif;

if (!function_exists('investment_status_format_content')):

    function investment_status_format_content() {
        global $post;
        $meta_value = get_post_meta($post->ID, '_format_status_embed', true);
        if ($meta_value != '') {
            $style = '';
            $background_type = get_post_meta($post->ID, 'status_background_type', true);

            if (($background_type == 'featured') && has_post_thumbnail($post->ID)) {
                $fullImage = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                $imageurl = $fullImage[0];
            } else {
                $imageurl = get_post_meta($post->ID, '_format_status_image', true);
            }
            $style = ' style="background-image: url(' . esc_url($imageurl) . ')"';
            $tag = 'iframe';
            echo '<div class="twitter-holder"' . $style . '>
      <' . $tag . '  height=240 width=500  scrolling=no src="http://twitframe.com/show?url=' . esc_url($meta_value) . '"></' . $tag . '>
    </div>';
        }
    }

endif;

if (!function_exists('investment_quote_format_content')):

    function investment_quote_format_content() {
        global $post;
        $meta_value = get_post_meta($post->ID, '_format_quote_text', true);
        if ($meta_value != '') {
            $style = '';
            $background_type = get_post_meta($post->ID, 'quote_background_type', true);

            if (($background_type == 'featured') && has_post_thumbnail($post->ID)) {
                $fullImage = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                $imageurl = $fullImage[0];
            } else {
                $imageurl = get_post_meta($post->ID, '_format_quote_image', true);
            }
            $style = ' style="background-image: url(' . esc_url($imageurl) . ')"';

            $name = get_post_meta($post->ID, '_format_quote_name', true);

            echo '<div class="blog-post qutoe-wrap"' . $style . '>
			    <div class="post-content"> 
			      <div class="post-info text-center">
			        <span class="post-format-icon">&ldquo;</span>
			      </div><!-- .post-info -->
			      
			      <div class="entry-summary qutoe-content text-center">
			          <p><span>&ldquo;</span> ' . esc_attr($meta_value) . ' <span>&rdquo;</span></p>
			      <div class="shape1"><i class="perch perch-cross-leaf"></i></div>
			      ' . (($name != '') ? '<h3 class="post-title">' . esc_attr($name) . '</h3>' : '') . '
			      </div><!-- .entry-summary -->                      
			    </div><!-- .post-content -->
			  </div><!-- .blog-post --> ';
        }
    }

endif;

if (!function_exists('investment_link_format_content')):

    function investment_link_format_content() {
        global $post;
        $linkurl = get_post_meta($post->ID, '_format_link_url', true);
        $title = get_post_meta($post->ID, '_format_link_title', true);

        $style = '';
        if (has_post_thumbnail($post->ID)) {
            $fullImage = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
            $imageurl = $fullImage[0];
            $style = ' style="background-image: url(' . esc_url($imageurl) . ')"';
        }

        $title = ($title != '') ? $title : get_the_title();
        echo '<div class="link-holder text-center"' . $style . '>
	    <div class="link-content">
	      <i class="fa fa-link format-link-icon"></i>
	      <h3 class="post-title"><a href="' . get_permalink($post->ID) . '" title="' . esc_attr($title) . '">' . esc_attr($title) . '</a></h3>
	      ' . (($linkurl != '') ? '<a href="' . esc_url($linkurl) . '" target="_blank" class="link"><span>' . esc_url($linkurl) . '</span></a>' : '') . '
	    </div>
	</div>';
    }

endif;

class Investment_Walker_Menu extends Walker_Nav_Menu {

    /**
     * @see Walker::start_lvl()
     * @since 3.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int $depth Depth of page. Used for padding.
     */
    public function start_lvl(&$output, $depth = 0, $args = array()) {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul role=\"menu\" class=\" dropdown-menu\">\n";
    }

    /**
     * @see Walker::start_el()
     */
    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
        $indent = ( $depth ) ? str_repeat("\t", $depth) : '';
        /**
         * Dividers, Headers or Disabled
         * =============================
         * Determine whether the item is a Divider, Header, Disabled or regular
         * menu item. To prevent errors we use the strcasecmp() function to so a
         * comparison that is not case sensitive. The strcasecmp() function returns
         * a 0 if the strings are equal.
         */
        if (strcasecmp($item->attr_title, 'divider') == 0 && $depth === 1) {
            $output .= $indent . '<li role="presentation" class="divider">';
        } else if (strcasecmp($item->title, 'divider') == 0 && $depth === 1) {
            $output .= $indent . '<li role="presentation" class="divider">';
        } else if (strcasecmp($item->attr_title, 'dropdown-header') == 0 && $depth === 1) {
            $output .= $indent . '<li role="presentation" class="dropdown-header">' . esc_attr($item->title);
        } else if (strcasecmp($item->attr_title, 'disabled') == 0) {
            $output .= $indent . '<li role="presentation" class="disabled"><a href="#">' . esc_attr($item->title) . '</a>';
        } else {
            $class_names = $value = '';
            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;
            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
            if ($args->has_children)
                $class_names .= ' dropdown';
            $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
            $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args);
            $id = $id ? ' id="' . esc_attr($id) . '"' : '';
            $output .= $indent . '<li' . $id . $value . $class_names . '>';
            $atts = array();
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';
            $atts['href'] = !empty($item->url) ? $item->url : '';

            $link_classes = [];
            if ($depth == 0) {
                $link_classes[] = 'first-lavel-item nav-link';
            }

            if (in_array('current-menu-item', $classes)) {
                $link_classes[] = 'active';
            }
            if (in_array('current-menu-parent', $classes)) {
                $link_classes[] = 'active';
            }

            $atts['class'] = join(' ', array_unique($link_classes));

            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args);
            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $value = ( 'href' === $attr ) ? esc_url($value) : esc_attr($value);
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }
            $item_output = $args->before;

            $item_output .= '<a' . $attributes . '>';
            $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
            $item_output .= '</a>';
            $item_output .= $args->after;
            $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
        }
    }

    /**
     * Traverse elements to create list from elements.
     *
     * Display one element if the element doesn't have any children otherwise,
     * display the element and its children. Will only traverse up to the max
     * depth and no ignore elements under that depth.
     *
     * This method shouldn't be called directly, use the walk() method instead.
     */
    public function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output) {
        if (!$element)
            return;
        $id_field = $this->db_fields['id'];
        // Display this element.
        if (is_object($args[0]))
            $args[0]->has_children = !empty($children_elements[$element->$id_field]);
        parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
    }

    /**
     * Menu Fallback
     * =============
     * If this function is assigned to the wp_nav_menu's fallback_cb variable
     * and a manu has not been assigned to the theme location in the WordPress
     * menu manager the function with display nothing to a non-logged in user,
     * and will add a link to the WordPress menu manager if logged in as an admin.
     *
     * @param array $args passed from the wp_nav_menu function.
     *
     */
    public static function fallback($args) {
        if (current_user_can('manage_options')) {
            if (!isset($args['fallback_title']))
                $args['fallback_title'] = __('Menu settings', 'investment');
            extract($args);
            $fb_output = null;
            if ($container) {
                $fb_output = '<' . $container;
                if ($container_id)
                    $fb_output .= ' id="' . $container_id . '"';
                if ($container_class)
                    $fb_output .= ' class="' . $container_class . '"';
                $fb_output .= '>';
            }
            $fb_output .= '<ul';
            if ($menu_id)
                $fb_output .= ' id="' . $menu_id . '"';
            if ($menu_class)
                $fb_output .= ' class="' . $menu_class . '"';
            $fb_output .= '>';
            $fb_output .= '<li><a href="' . admin_url('nav-menus.php') . '">' . $fallback_title . '</a></li>';
            $fb_output .= '</ul>';
            if ($container)
                $fb_output .= '</' . $container . '>';
            echo force_balance_tags($fb_output);
        }
    }
}

function investment_image_gallery($gallery, $echo = true, $atts = array()) {
    if ($gallery == '')
        return false;

    extract(shortcode_atts(array(
        'large_img_size' => 'investment-630x335-crop',
        'thumb_img_size' => 'investment-300x300-crop',
                    ), $atts));

    $arr = $gallery;
    if (is_string($gallery)) {
        $arr = explode(',', $gallery);
    }
    $arr = array_filter($arr);
    if (!empty($arr)) {
        $count = $remain = 0;
        $moreclass = (count($arr) > 3) ? ' plusmore' : '';
        echo '<div class="row g-5 investment-image-gallery' . $moreclass . '">';
        foreach ($arr as $key => $value) {
            $size = ( $count > 0 ) ? $thumb_img_size : $large_img_size;
            $class = ( $count > 0 ) ? 'col-lg-6 col-sm-6 col-6 image' . $count : 'col-lg-12 col-sm-12 col-xs-12 image' . $count;
            $image = wp_get_attachment_image_src($value, $size);

            $thumb = $image;

            $image = wp_get_attachment_image_src($value, 'full');

            if ($image) {
                $fullimage = $image[0];
            } else {
                $fullimage = '#';
            }

            $title = get_the_title($value);

            if ($count > 2) {
                echo '<a class="hidden" href="' . $fullimage . '" title="' . $title . '"></a>';
            } else {
                if (($count == 2) && (count($arr) > 3) && $thumb) {
                    echo '<div class="' . $class . '"><div><a href="' . $fullimage . '" title="' . $title . '">' . (count($arr) - 3) . '+</a><img src="' . $thumb[0] . '" alt=""></div></div>';
                } else {
                    if ($thumb) {
                        echo '<div class="' . $class . '"><div><a href="' . $fullimage . '" title="' . $title . '"><img src="' . $thumb[0] . '" alt=""></a></div></div>';
                    }
                }
            }
            $count++;
        }

        echo '</div>';
    }
}

function investment_page_wrapper_class($class = "") {
    $classArr = array(
        'page-wrapper',
        'position-relative',
        'overflow-x-hidden',
        $class
    );

    if (!is_page() && ('post' != get_post_type())) {
        $classArr[] = 'page-wrapper-' . get_post_type();
    }
    $classArr = array_filter($classArr);

    echo 'class="' . implode(' ', $classArr) . '"';
}

function investment_header_bg_style($post_id = '') {
    $style = $header_image = '';

    $post_id = ( $post_id == '' ) ? get_the_ID() : intval($post_id);
    if (in_array(get_post_type(), ['service', 'portfolio', 'job', 'partner', 'team'])) {
        $post_id = get_option(get_post_type() . '_archive_id');
    }



    $header_image = get_post_meta($post_id, 'header_image', true);

    if (is_singular(array('service', 'portfolio'))) {
        $header_image = get_the_post_thumbnail_url(get_the_ID(), 'full');
    }

    if (!empty(get_option('page_for_posts')) && (get_post_type() == 'post')) {
        $header_image = get_post_meta(get_option('page_for_posts'), 'header_image', true);
    }



    if (function_exists('wc_get_page_id') && (get_post_type() == 'product')) {
        $header_image = get_post_meta(wc_get_page_id('shop'), 'header_image', true);
    }
    // if( !file_exists($header_image) ){
    // 	$header_image = str_replace(INVESTMENT_URI, INVESTMENT_ASSETS, $header_image);
    // }

    $style = ($header_image != '') ? '--banner-bg-image: url(' . esc_url($header_image) . ');' : '';

    return $style;
}

function invetment_add_nav_menu_classes($classes, $item) {

    if (get_post_status(get_option('partner_archive_id')) == 'publish') {
        $mypost = get_post(get_option('partner_archive_id'));
        $title = $mypost->post_title;

        if (is_post_type_archive('partner') && ($item->title == $title )) {
            $classes[] = 'current-menu-item current_page_item active';
        }
    }

    if (get_post_status(get_option('service_archive_id')) == 'publish') {
        $mypost = get_post(get_option('service_archive_id'));
        $title = $mypost->post_title;

        if (is_post_type_archive('service') && ($item->title == $title )) {
            $classes[] = 'current-menu-item current_page_item active';
        }
    }

    if (get_post_status(get_option('portfolio_archive_id')) == 'publish') {
        $mypost = get_post(get_option('portfolio_archive_id'));
        $title = $mypost->post_title;

        if (is_post_type_archive('portfolio') && ($item->title == $title )) {
            $classes[] = 'current-menu-item current_page_item active';
        }
    }

    if (get_post_status(get_option('team_archive_id')) == 'publish') {
        $mypost = get_post(get_option('team_archive_id'));
        $title = $mypost->post_title;

        if (is_post_type_archive('team') && ($item->title == $title )) {
            $classes[] = 'current-menu-item current_page_item active';
        }
    }

    if (get_post_status(get_option('job_archive_id')) == 'publish') {
        $mypost = get_post(get_option('job_archive_id'));
        $title = $mypost->post_title;

        if (is_post_type_archive('job') && ($item->title == $title )) {
            $classes[] = 'current-menu-item current_page_item active';
        }
    }


    return $classes;
}

add_filter('nav_menu_css_class', 'invetment_add_nav_menu_classes', 10, 2);

/**
 * Fix active class in nav for post types archive page.
 *
 * @param array $menu_items Menu items.
 * @return array
 */
function investment_nav_menu_item_classes($menu_items) {
    $post_type_arr = array('portfolio', 'service', 'team', 'partner', 'job');
    if (!in_array(get_post_type(), $post_type_arr)) {
        return $menu_items;
    }
    $page_for_posts = (int) get_option('page_for_posts');

    if (!empty($menu_items) && is_array($menu_items)) {
        foreach ($menu_items as $key => $menu_item) {
            $classes = (array) $menu_item->classes;
            $menu_id = (int) $menu_item->object_id;

            // Unset active class for blog page.
            if ($page_for_posts === $menu_id) {
                $menu_items[$key]->current = false;

                if (in_array('current_page_parent', $classes, true)) {
                    unset($classes[array_search('current_page_parent', $classes, true)]);
                }

                if (in_array('current-menu-item', $classes, true)) {
                    unset($classes[array_search('current-menu-item', $classes, true)]);
                }
            }
            $menu_items[$key]->classes = array_unique($classes);
        }
    }

    return $menu_items;
}

add_filter('wp_nav_menu_objects', 'investment_nav_menu_item_classes', 2);

if (!function_exists('investment_service_archive_content')):

    function investment_service_archive_content() {
        if (get_post_status(get_option('service_archive_id')) == 'publish') {
            $page_id = get_option('service_archive_id');
            $post = get_post($page_id);
            echo apply_filters('the_content', $post->post_content);
        }
    }

endif;

if (!function_exists('investment_team_archive_content')):

    function investment_team_archive_content() {
        if (get_post_status(get_option('team_archive_id')) == 'publish') {
            $page_id = get_option('team_archive_id');
            $post = get_post($page_id);
            echo apply_filters('the_content', $post->post_content);
        }
    }

endif;

if (!function_exists('investment_partner_archive_content')):

    function investment_partner_archive_content() {
        if (get_post_status(get_option('partner_archive_id')) == 'publish') {
            $page_id = get_option('partner_archive_id');
            $post = get_post($page_id);
            echo apply_filters('the_content', $post->post_content);
        }
    }

endif;

if (!function_exists('investment_portfolio_archive_content')):

    function investment_portfolio_archive_content() {
        if (get_post_status(get_option('portfolio_archive_id')) == 'publish') {
            $page_id = get_option('portfolio_archive_id');
            $post = get_post($page_id);
            echo apply_filters('the_content', $post->post_content);
        }
    }

endif;

/* Team tag && size options */

function investment_get_team_title_tag() {
    $tag = ot_get_option('single_team_title_tag', 'h2');
    $tag = ( $tag != '' ) ? $tag : 'h3';
    return esc_attr($tag);
}

function investment_team_title_before() {
    $tag = investment_get_team_title_tag();
    $tag_size = ot_get_option('single_team_tag_size', '');

    $font_size = 'fs-3';
    switch ($tag_size) {
        case 'xl' :
            $font_size = 'fs-1';
            break;

        case 'lg' :
            $font_size = 'fs-2';
            break;

        case 'md' :
            $font_size = 'fs-3';
            break;

        case 'sm' :
            $font_size = 'fs-4';
            break;

        case 'xs' :
            $font_size = 'fs-6';
            break;

        default :
            $font_size = 'fs-3';
            break;
    }

    $format = ($tag_size == '') ? '<%s>' : '<%s class="%s">';
    return sprintf($format, $tag, $font_size);
}

function investment_team_title_after() {
    $tag = investment_get_team_title_tag();
    return sprintf('</%s>', $tag);
}

/* Single post tag && size options */

function investment_get_single_post_title_tag() {
    $tag = ot_get_option('single_post_title_tag', 'h3');
    $tag = ( $tag != '' ) ? $tag : 'h3';
    return esc_attr($tag);
}

function investment_single_post_title_before() {
    $tag = investment_get_single_post_title_tag();
    $tag_size = ot_get_option('single_post_title_tag_size', 'post-title');
    $tag_size = ($tag_size != 'post-title') ? $tag . '-' . $tag_size : $tag_size;

    return sprintf('<%s class="%s fs-1">', $tag, $tag_size);
}

function investment_single_post_title_after() {
    $tag = investment_get_single_post_title_tag();
    return sprintf('</%s>', $tag);
}

function investment_title_tag_std() {
    return array(
        array(
            'value' => 'h1',
            'label' => esc_attr__('H1', 'investment'),
        ),
        array(
            'value' => 'h2',
            'label' => esc_attr__('H2', 'investment'),
        ),
        array(
            'value' => 'h3',
            'label' => esc_attr__('H3', 'investment'),
        ),
        array(
            'value' => 'h4',
            'label' => esc_attr__('H4', 'investment'),
        ),
        array(
            'value' => 'h5',
            'label' => esc_attr__('H5', 'investment'),
        ),
        array(
            'value' => 'h6',
            'label' => esc_attr__('H6', 'investment'),
        ),
    );
}

function investment_title_tag_size_std() {
    return array(
        array(
            'value' => '',
            'label' => esc_attr__('Default', 'investment'),
        ),
        array(
            'value' => 'xl',
            'label' => esc_attr__('Extra large', 'investment'),
        ),
        array(
            'value' => 'lg',
            'label' => esc_attr__('Large', 'investment'),
        ),
        array(
            'value' => 'md',
            'label' => esc_attr__('Medium', 'investment'),
        ),
        array(
            'value' => 'sm',
            'label' => esc_attr__('Small', 'investment'),
        ),
        array(
            'value' => 'xs',
            'label' => esc_attr__('Extra small', 'investment'),
        )
    );
}

add_filter('investment_portfolio_category_slug', 'investment_portfolio_category_slug_callback');

function investment_portfolio_category_slug_callback() {
    return ot_get_option('portfolio_category_slug', 'portfolio_category');
}

add_filter('investment_portfolio_tag_slug', 'investment_portfolio_category_tag_callback');

function investment_portfolio_category_tag_callback() {
    return ot_get_option('portfolio_tag_slug', 'ptag');
}

//switch old class to new class
$investment_class_map = array(
    'primary-bg' => 'bg-primary',
    'gray_bg' => 'bg-light',
    'gray-bg' => 'bg-light',
    'secondary-bg-dark' => 'bg-dark',
    'secondary-dark-bg' => 'bg-dark',
    'has-darkbg' => 'text-light',
    'secondary-light-bg' => 'bg-secondary-light',
    // wpbackery
    'vc_row' => 'row',
    'wpb_row' => 'row',
    'contact-block' => [
        'list-unstyled',
        'mb-30'
    ]
);

$GLOBALS['investment_class_map'] = $investment_class_map;

/**
 * @param string|array $classes  required
 * @param array $args (optional) 
 * 
 * Class map is required, it should be associative array
 * $investment_class_map is a global class_map variable
 * 
 * @return string|array
 */
function investment_switch_classes($classes, $args = []) {
    if (is_string($classes))
        $classesArr = explode(" ", $classes);

    // duplicate & empty value removed
    $classesArr = array_unique(array_filter($classesArr));
    if (empty($classesArr))
        return $classes;

    global $investment_class_map;
    extract(wp_parse_args($args, [
        'return_array' => false,
        'class_map' => $investment_class_map
    ]));

    foreach ($classesArr as $key => $value) {
        if (array_key_exists($value, $class_map)) {
            $new_value = $class_map[$value];

            if (is_array($new_value)) {
                $value = $value . ' ' . join(' ', $new_value);
            } else {
                $value = $new_value;
            }
        }

        $classesArr[$key] = $value;
    }

    // duplicate & empty value removed
    $classesArr = array_unique(array_filter($classesArr));

    if ($return_array)
        return $classesArr;
    return implode(" ", $classesArr);
}

add_filter('paginate_links_output', 'investment_paginate_links_output', 10, 2);

function investment_paginate_links_output($output, $args) {
    global $wp_query, $wp_rewrite;

    // Setting up default values based on the current URL.
    $pagenum_link = html_entity_decode(get_pagenum_link());
    $url_parts = explode('?', $pagenum_link);

    // Get max pages and current page out of the current query, if available.
    $total = isset($wp_query->max_num_pages) ? $wp_query->max_num_pages : 1;
    $current = get_query_var('paged') ? (int) get_query_var('paged') : 1;

    // Append the format placeholder to the base URL.
    $pagenum_link = trailingslashit($url_parts[0]) . '%_%';

    // URL base depends on permalink settings.
    $format = $wp_rewrite->using_index_permalinks() && !strpos($pagenum_link, 'index.php') ? 'index.php/' : '';
    $format .= $wp_rewrite->using_permalinks() ? user_trailingslashit($wp_rewrite->pagination_base . '/%#%', 'paged') : '?paged=%#%';

    $defaults = array(
        'base' => $pagenum_link, // http://example.com/all_posts.php%_% : %_% is replaced by format (below).
        'format' => $format, // ?page=%#% : %#% is replaced by the page number.
        'total' => $total,
        'current' => $current,
        'aria_current' => 'page',
        'show_all' => false,
        'prev_next' => true,
        'prev_text' => __('&laquo; Previous'),
        'next_text' => __('Next &raquo;'),
        'end_size' => 1,
        'mid_size' => 2,
        'type' => 'list',
        'list_class' => 'pagination gap-2',
        'list_li_class' => 'page-item',
        'list_link_class' => 'page-link',
        'active_class' => 'active',
        'add_args' => array(), // Array of query args to add.
        'add_fragment' => '',
        'before_page_number' => '',
        'after_page_number' => '',
    );

    $args = wp_parse_args($args, $defaults);

    if (!is_array($args['add_args'])) {
        $args['add_args'] = array();
    }

    // Merge additional query vars found in the original URL into 'add_args' array.
    if (isset($url_parts[1])) {
        // Find the format argument.
        $format = explode('?', str_replace('%_%', $args['format'], $args['base']));
        $format_query = isset($format[1]) ? $format[1] : '';
        wp_parse_str($format_query, $format_args);

        // Find the query args of the requested URL.
        wp_parse_str($url_parts[1], $url_query_args);

        // Remove the format argument from the array of query arguments, to avoid overwriting custom format.
        foreach ($format_args as $format_arg => $format_arg_value) {
            unset($url_query_args[$format_arg]);
        }

        $args['add_args'] = array_merge($args['add_args'], urlencode_deep($url_query_args));
    }

    // Who knows what else people pass in $args.
    $total = (int) $args['total'];
    if ($total < 2) {
        return;
    }
    $current = (int) $args['current'];
    $end_size = (int) $args['end_size']; // Out of bounds? Make it the default.
    if ($end_size < 1) {
        $end_size = 1;
    }
    $mid_size = (int) $args['mid_size'];
    if ($mid_size < 0) {
        $mid_size = 2;
    }

    $add_args = $args['add_args'];
    $r = '';
    $page_links = array();
    $dots = false;

    if ($args['prev_next'] && $current && 1 < $current) :
        $link = str_replace('%_%', 2 == $current ? '' : $args['format'], $args['base']);
        $link = str_replace('%#%', $current - 1, $link);
        if ($add_args) {
            $link = add_query_arg($add_args, $link);
        }
        $link .= $args['add_fragment'];

        $page_links[] = sprintf(
                '<a class="prev page-numbers %1$s" href="%2$s">%3$s</a>',
                $args['list_link_class'],
                esc_url(apply_filters('paginate_links', $link)),
                $args['prev_text']
        );
    endif;
    $list_li_class = $args['list_li_class'];
    for ($n = 1; $n <= $total; $n++) :
        if ($n == $current) :
            $active_li_class = $args['list_li_class'] . ' ' . $args['active_class'];
            $page_links[] = sprintf(
                    '%4$s<span aria-current="%1$s" class="page-numbers %2$s current">%3$s</span>%5$s',
                    esc_attr($args['aria_current']),
                    $args['list_link_class'],
                    $args['before_page_number'] . number_format_i18n($n) . $args['after_page_number'],
                    $args['type'] == 'list' ? '<li class="' . $active_li_class . '">' : '',
                    $args['type'] == 'list' ? '</li>' : '',
            );

            $dots = true;
        else :
            if ($args['show_all'] || ( $n <= $end_size || ( $current && $n >= $current - $mid_size && $n <= $current + $mid_size ) || $n > $total - $end_size )) :
                $link = str_replace('%_%', 1 == $n ? '' : $args['format'], $args['base']);
                $link = str_replace('%#%', $n, $link);
                if ($add_args) {
                    $link = add_query_arg($add_args, $link);
                }
                $link .= $args['add_fragment'];

                $page_links[] = sprintf(
                        '%4$s<a class="page-numbers %1$s" href="%2$s">%3$s</a>%5$s',
                        /** This filter is documented in wp-includes/general-template.php */
                        $args['list_link_class'],
                        esc_url(apply_filters('paginate_links', $link)),
                        $args['before_page_number'] . number_format_i18n($n) . $args['after_page_number'],
                        $args['type'] == 'list' ? '<li class="' . $list_li_class . '">' : '',
                        $args['type'] == 'list' ? '</li>' : '',
                );

                $dots = true;
            elseif ($dots && !$args['show_all']) :
                $page_links[] = sprintf(
                        '%2$s<span class="page-numbers %1$s dots">' . __('&hellip;') . '</span>%3$s',
                        $args['list_link_class'],
                        $args['type'] == 'list' ? '<li class="' . $list_li_class . '">' : '',
                        $args['type'] == 'list' ? '</li>' : '',
                );

                $dots = false;
            endif;
        endif;
    endfor;

    if ($args['prev_next'] && $current && $current < $total) :
        $link = str_replace('%_%', $args['format'], $args['base']);
        $link = str_replace('%#%', $current + 1, $link);
        if ($add_args) {
            $link = add_query_arg($add_args, $link);
        }
        $link .= $args['add_fragment'];

        $page_links[] = sprintf(
                '%4$s<a class="next page-numbers %1$s" href="%2$s">%3$s</a>%5$s',
                $args['list_link_class'],
                /** This filter is documented in wp-includes/general-template.php */
                esc_url(apply_filters('paginate_links', $link)),
                $args['next_text'],
                $args['type'] == 'list' ? '<li class="' . $list_li_class . '">' : '',
                $args['type'] == 'list' ? '</li>' : '',
        );
    endif;

    switch ($args['type']) {
        case 'array':
            return $page_links;

        case 'list':

            $r .= sprintf("<ul class='%s'>\n\t", $args['list_class']);
            $r .= implode("\n", $page_links);
            $r .= "\n</ul>\n";
            break;

        default:
            $r = implode("\n", $page_links);
            break;
    }

    /**
     * Filters the HTML output of paginated links for archives.
     *
     * @since 5.7.0
     *
     * @param string $r    HTML output.
     * @param array  $args An array of arguments. See paginate_links()
     *                     for information on accepted arguments.
     */
    $output = apply_filters('investment_paginate_links_output', $r, $args);

    return $output;
}

function investment_img_size_dropdown() {
    $img_sizes = investment_get_image_sizes_Arr();
    if (!is_array($img_sizes) || empty($img_sizes))
        return;

    $dropdown = [];
    foreach ($img_sizes as $key => $size) {
        $dropdown[] = [
            'value' => $key,
            'label' => $size
        ];
    }
    return $dropdown;
}

if (function_exists('is_woocommerce')) {
    include get_template_directory() . '/includes/control-woocommerce.php';
}

if (!function_exists('investment_get_offcanvas_header')) {

    function investment_get_offcanvas_header($args, $echo = false) {
        ob_start();
        get_template_part('template-parts/header/offcanvas-header', '', $args);

        if ($echo)
            echo ob_get_clean();

        return ob_get_clean();
    }

}

if (!function_exists('investment_menu_atts')) {

    function investment_menu_atts($args = []) {
        $mobile_menu_style = ot_get_option('mobile_menu_style', 'offcanvas');
        $before = !empty($args) ? investment_get_offcanvas_header($args) : '';

        if ($mobile_menu_style == 'offcanvas' && !empty($before)) {
            $before = '<div class="offcanvas-body gap-lg-30 align-items-center">' . $before;
        }

        $menu_atts = [
            'toggle' => $mobile_menu_style,
            'target' => $mobile_menu_style == 'collapse' ? 'navbarSupportedContent' : 'offcanvasNavbar',
            'container_class' => $mobile_menu_style == 'collapse' ? 'collapse navbar-collapse gap-20' : 'offcanvas offcanvas-xl offcanvas-end d-lg-flex',
            'items_wrap_before' => $mobile_menu_style == 'collapse' ? '' : $before,
            'items_wrap_after' => $mobile_menu_style == 'collapse' ? '' : '</div>',
        ];

        return $menu_atts;
    }

}

if (!function_exists('investment_get_page_by_title')) {

    function investment_get_page_by_title($title) {
        if (empty($title))
            return null;

        $posts = get_posts(
                array(
                    'post_type' => 'page',
                    'title' => $title
                )
        );

        $page_got_by_title = null;

        if (!empty($posts)) {
            $page_got_by_title = $posts[0];
        }

        return $page_got_by_title;
    }

}
if(!function_exists('investment_get_map_center')){
    function investment_get_map_center($coordinates) {
    $numCoords = count($coordinates);
    $totalLat = 0;
    $totalLng = 0;

    // Sum up all latitudes and longitudes
    foreach ($coordinates as $coord) {
        $totalLat += $coord['lat'];
        $totalLng += $coord['lng'];
    }

    // Calculate average latitude and longitude
    $avgLat = $totalLat / $numCoords;
    $avgLng = $totalLng / $numCoords;

    return array('lat' => $avgLat, 'lng' => $avgLng);
}
}