<?php
if ( ! function_exists( 'investment_fonts_url' ) ) :
/**
 * Register Google fonts for Twenty Fifteen.
 *
 * @return string Google fonts URL for the theme.
 */
function investment_fonts_url() {
	$fonts_url = '';
	$fonts     = array();

	/*
	 * Translators: If there are characters in your language that are not supported
	 */
	$fonts = array('Cardo:400,700,400italic', 'Lato:400,900italic,900,700italic,700,400italic,300italic,300,100italic,100');

	$subsets   = 'latin,latin-ext';
	$subset = 'no-subset';

	if ( 'cyrillic' == $subset ) {
		$subsets .= ',cyrillic,cyrillic-ext';
	} elseif ( 'greek' == $subset ) {
		$subsets .= ',greek,greek-ext';
	} elseif ( 'devanagari' == $subset ) {
		$subsets .= ',devanagari';
	} elseif ( 'vietnamese' == $subset ) {
		$subsets .= ',vietnamese';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), '//fonts.googleapis.com/css' );
	}

	return $fonts_url;
}
endif;

/**
 * JavaScript Detection.
 *
 * Adds a `js` class to the root `<html>` element when JavaScript is detected.
 *
 */
function investment_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'investment_javascript_detection', 0 );

function investment_template_assets_register(){
	wp_register_style( 'vegas', INVESTMENT_ASSETS . '/css/vegas.css', array(), null );
	wp_register_style( 'unite-gallery', INVESTMENT_ASSETS . '/css/unite-gallery.css', array(), '1.0' );


	wp_register_style( 'investment-tablesorter', INVESTMENT_ASSETS. '/css/tablesorter.min.css', false, INVESTMENT_VERSION );
	wp_register_script( 'jquery-tablesorter', INVESTMENT_ASSETS. '/js/jquery.tablesorter.min.js', array( 'jquery' ), '1.0', true );
	wp_register_script( 'jquery-tablesorter-widgets', INVESTMENT_ASSETS. '/js/jquery.tablesorter.widgets.min.js', array( 'jquery-tablesorter' ), '1.0', true );
}

add_action( 'wp_enqueue_scripts', 'investment_template_assets_register' );

// Register Style
function investment_styles() {

	$suffix = is_rtl()? '.rtl' : '';

	wp_enqueue_style( 'ot-google-fonts', investment_fonts_url(), array(), null );
	wp_enqueue_style( 'fontawesome' );
	
	wp_enqueue_style( 'theme-dark', INVESTMENT_ASSETS. '/css/theme-dark.css', false, INVESTMENT_VERSION );
	

	wp_enqueue_style( 'owl-carousel', INVESTMENT_ASSETS. '/css/owl.carousel.css', false, '1.0' );
	wp_enqueue_style( 'linea', INVESTMENT_ASSETS. '/css/linea.css', false, '1.0' );
	wp_enqueue_style( 'pe-icon-7-stroke', INVESTMENT_ASSETS . '/css/pe-icon-7-stroke.css', array(), '1.0' );
	wp_enqueue_style( 'magnific-popup', INVESTMENT_ASSETS. '/css/magnific-popup.css', false, '1.0' );
	wp_enqueue_style( 'animate', INVESTMENT_ASSETS. '/css/animate.css', false, '1.0' );
	wp_enqueue_style( 'investment-perch', INVESTMENT_ASSETS . '/css/perch.css', array(), INVESTMENT_VERSION );		
	wp_enqueue_style( 'investment-strock', INVESTMENT_ASSETS. '/css/strock.css', false, INVESTMENT_VERSION );	
	wp_register_style( 'jquery-ui-datepicker-style', INVESTMENT_ASSETS. '/css/jquery-ui.css', false, INVESTMENT_VERSION );	

	wp_enqueue_style( 'investment-theme', INVESTMENT_ASSETS. '/css/theme'.$suffix.'.min.css', false, INVESTMENT_VERSION );
	wp_enqueue_style( 'investment-styles', INVESTMENT_ASSETS. '/css/style'.$suffix.'.css', false, INVESTMENT_VERSION );

	wp_enqueue_style( 'investment-menu', INVESTMENT_ASSETS. '/css/menu.css', false, INVESTMENT_VERSION );

	
	wp_enqueue_style( 'investment-elementor', INVESTMENT_ASSETS. '/css/elementor.css', false, INVESTMENT_VERSION );
	
	if( function_exists('is_woocommerce') ){
		wp_dequeue_style( 'woocommerce-layout' );
		wp_dequeue_style( 'woocommerce-general' );
		wp_dequeue_style( 'woocommerce-smallscreen' );
    	wp_enqueue_style( 'investment-woocommerce', INVESTMENT_ASSETS . '/css/woocommerce.css', false, INVESTMENT_VERSION );
	}	
	if( function_exists('is_bbpress') ){
		if( is_bbpress() ){
			wp_dequeue_style( 'bbp-default' );
			wp_enqueue_style( 'investment-bbp', INVESTMENT_ASSETS . '/css/bbpress.css', false, INVESTMENT_VERSION );
		}
	}
	if ( function_exists( 'is_buddypress' ) ) { 		
			wp_dequeue_style( 'bp-legacy-css' );
			wp_enqueue_style( 'investment-buddypress', INVESTMENT_ASSETS . '/css/buddypress.css', false, INVESTMENT_VERSION );		
	}

	//wp_enqueue_style( 'investment', INVESTMENT_ASSETS.'/css/investment.css', false, INVESTMENT_VERSION );
	wp_enqueue_style( 'investment-style', INVESTMENT_URI.'/style.css', false, INVESTMENT_VERSION );

	wp_register_script( 'modernizr-custom', INVESTMENT_ASSETS. '/js/modernizr.custom.js', false, INVESTMENT_VERSION, false );
	wp_enqueue_script( 'modernizr-custom' );
        wp_register_style('investment-osm-style', INVESTMENT_ASSETS.'/js/leaflet/leaflet.css');


}
add_action( 'wp_enqueue_scripts', 'investment_styles' );

// Register Script
function investment_scripts() {
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	wp_register_script( 'vegas', INVESTMENT_ASSETS . '/js/vegas.min.js', array( 'jquery' ), '1.0', true ); 

	wp_enqueue_script( 'bootstrap-bundle', INVESTMENT_ASSETS. '/js/bootstrap.bundle.min.js', false, '5.2.1', false );
	wp_enqueue_script( 'owl-carousel', INVESTMENT_ASSETS. '/js/owl.carousel.min.js', false, '1.0', true );
	wp_enqueue_script( 'jquery-fitvids', INVESTMENT_ASSETS. '/js/jquery.fitvids.js', array( 'jquery' ), '1.0', true );
	wp_register_script( 'vidbg', INVESTMENT_ASSETS. '/js/vidbg.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'isotope-pkgd', INVESTMENT_ASSETS. '/js/isotope.pkgd.min.js', array( 'jquery' ), '3.0.6', true );
	wp_enqueue_script( 'responsive-tabs', INVESTMENT_ASSETS. '/js/responsive-tabs.js', array( 'jquery' ), '1.0', true );

	wp_register_script( 'unitegallery', INVESTMENT_ASSETS . '/js/unitegallery.min.js', array( 'jquery' ), '1.0', false );
	wp_register_script( 'ug-theme-tiles', INVESTMENT_ASSETS . '/js/themes/tiles/ug-theme-tiles.js', array( 'jquery', 'unitegallery' ), '1.0', false );

	wp_register_script( 'waypoints', INVESTMENT_ASSETS . '/js/waypoints.min.js', array( 'jquery' ), '1.0', false );
	wp_register_script( 'jquery-counterup', INVESTMENT_ASSETS . '/js/jquery.counterup.min.js', array( 'jquery', 'waypoints' ), '1.0', false );
	wp_register_script( 'skillbar', INVESTMENT_ASSETS . '/js/skillbar.js', array( 'jquery', 'waypoints' ), '1.0', false );

	

	wp_register_script( 'jquery-magnific-popup', INVESTMENT_ASSETS. '/js/jquery.magnific-popup.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'jquery-magnific-popup' );
	wp_enqueue_script( 'echo', INVESTMENT_ASSETS .'/js/echo.js' , array('jquery'), INVESTMENT_VERSION );	

	wp_enqueue_script( 'investment-menu', INVESTMENT_ASSETS. '/js/menu.js', array( 'jquery' ), INVESTMENT_VERSION, true );
	

	
	wp_register_script( 'jquery-scrollto', INVESTMENT_ASSETS. '/js/jquery.scrollto.js', array( 'jquery' ), INVESTMENT_VERSION, true );
	wp_register_script( 'onepage-nav', INVESTMENT_ASSETS. '/js/onepage-nav.js', array( 'jquery', 'jquery-scrollto' ), INVESTMENT_VERSION, true );
	wp_register_script( 'jquery-ajaxchimp', INVESTMENT_ASSETS . '/js/jquery.ajaxchimp.js', array( 'jquery' ), INVESTMENT_VERSION, false );
	wp_register_script( 'jquery-ajaxchimp-langs', INVESTMENT_ASSETS . '/js/jquery.ajaxchimp.langs.js', array( 'jquery-ajaxchimp' ), INVESTMENT_VERSION, false );
	wp_register_script( 'investment-mc-scripts', INVESTMENT_ASSETS. '/js/mc-scripts.js', array( 'jquery-ajaxchimp-langs' ), INVESTMENT_VERSION, true );
	wp_register_script( 'jquery-ui', INVESTMENT_ASSETS. '/js/jquery-ui.js', array( 'jquery' ), INVESTMENT_VERSION, true );
	

	$api = ot_get_option( 'google_map_api', '' );
	$api = ( $api != '' )? '&amp;key='.esc_attr($api) : '';
	wp_register_script( 'maps-google', '//maps.google.com/maps/api/js?sensor=false&amp;libraries=geometry&amp;v=3.7'.$api, array( 'jquery' ), '1.0', true );
	wp_register_script( 'leaflet', INVESTMENT_ASSETS. '/js/leaflet/leaflet.js', array(), '1.9.4', true );
        
	wp_register_script( 'investment-gmapscripts', INVESTMENT_ASSETS. '/js/gmapscripts.js', array( 'jquery', 'maps-google', 'investment-main' ), INVESTMENT_VERSION, true );
        wp_register_script( 'investment-osm-mapscripts', INVESTMENT_ASSETS. '/js/osm-mapscripts.js', array( 'jquery', 'leaflet' ), INVESTMENT_VERSION, true );
	
	

	wp_register_script( 'investment-main', INVESTMENT_ASSETS. '/js/main.js', array( 'jquery', 'jquery-magnific-popup', 'owl-carousel' ), INVESTMENT_VERSION, true );
	wp_enqueue_script( 'investment-main' );

	$arr = array( 
		'ajaxurl' => admin_url( 'admin-ajax.php' ),
		'THEME_URI' => INVESTMENT_URI,
		'preset_color' => ot_get_option('preset_color'),
		'menu_breakpoint' => ot_get_option('header_menu_breakpoint', '800'),
		'smmoth_scrolling' => ot_get_option( 'smmoth_scrolling', 'on' ),
		'scroliing_speed' => intval(ot_get_option( 'scroliing_speed', 500 ))
		);
	wp_localize_script( 'bootstrap-bundle', 'INVESTMENT', $arr );

}
add_action( 'wp_enqueue_scripts', 'investment_scripts' );
