<div class="author-info">
    <div class="pull-left">
    <?php
    /**
     * Filter the author info avatar size.
     *
     * @param int $size The avatar height and width size in pixels.
     */
    if ( has_wp_user_avatar(get_the_author_meta( 'user_email' )) ) {
            echo get_wp_user_avatar(get_the_author_meta( 'user_email' ), 'thumbnail');
      } else {
        $author_info_avatar_size = apply_filters( 'investment_author_info_avatar_size', 155 );
        echo get_avatar( get_the_author_meta( 'user_email' ), $author_info_avatar_size );
      }
    

    
    ?>
    </div>
    <div class="author-desc">
        <div class="author-title">
            <strong><?php echo get_the_author(); ?></strong>
            <ul class="list-inline pull-right">
                <li class="reply"><a href="#commentform"><?php echo __( 'Reply', 'investment' )?></a></li>
                <?php investment_get_user_contacts_list(); ?>                               
            </ul>
        </div>
        <p><?php the_author_meta( 'description' ); ?></p>
    </div>
</div><!-- .author-info -->