<?php
extract(wp_parse_args($args, array(
	'gallery_display' => 'yes',
	'large_img_size' => 'investment-630x335-crop',
	'thumb_img_size' => 'investment-300x300-crop',
    'tag' => 'h1',
	'title' => 'About Company', 
	'add_underline' => 'yes',
	'style' => 'underline_small',
	'gallery' => '',
	'footer_text' => '',
    'content' => ''
)));

$class = ( $add_underline == 'yes' )? $style : '';
$textblock_class = ($gallery == '')? 'col-lg-12' : 'col-lg-6';
$gallery_position = $gallery_display == 'yes' ? 'order-2' : 'order-0';
?>

<<?php echo esc_attr($tag) ?> class="<?php echo esc_attr($class) ?>">
	<?php echo investment_parse_text(esc_attr($title)) ?>
</<?php echo esc_attr($tag) ?>>

<div class="row about-gallery-details">
	<?php if($gallery != ''): ?>
	<div class="col-lg-6 <?php echo $gallery_position ?>">
		<?php echo investment_image_gallery($gallery, false, $args); ?>
	</div>
	<?php endif; ?>
	<div class="<?php echo esc_attr($textblock_class) ?> order-1">
		<div class="block-content">
			<?php 
			if(function_exists('wpb_js_remove_wpautop')){
				echo wpb_js_remove_wpautop($content, true);
			}else{
				echo wp_kses_post($content);
			}
			 ?>
		</div>
	</div>

	<?php if( $footer_text != '' ): ?>
	<div class="col-lg-12"><p><?php echo do_shortcode($footer_text) ?></p></div>
	<?php endif; ?>
</div>
