<?php
extract(wp_parse_args($args, array(
	'bg_type' => 'secondary-bg',
    'title' => 'Our clients are looking for YOU!',
    'subtitle' => '',
    'button_text' => 'Apply now',
    'button_url' => '#',
    'content' => ''
)));

$btnclass = ( $bg_type == 'primary-bg')? 'btn-secondary' : 'btn-primary';
$btnclass .= ' '.sanitize_title(esc_attr($button_text));

$dark_colors = array( 'primary-bg', 'secondary-bg', 'secondary-light-bg', 'dark-bg' );
$white_class = in_array($bg_type, $dark_colors)? 'has-darkbg-class text-white' : '';

$bg_class = 'bg-'.str_replace('-bg', '', $bg_type);

$classes = [
    'call-to-action',
    'text-center',
    'text-md-start',
    'p-40',
    $bg_class,
    $white_class
];

?>
<div class="<?php echo join( ' ', $classes) ?>">
	<div class="row d-flex gy-20">
		<div class="col-lg-8">
			<h3><?php echo investment_parse_text($title) ?></h3>
			<?php echo ($subtitle != '')? '<p class="smaller">'.force_balance_tags(nl2br($subtitle)).'</p>' : ''; ?>
		</div>
		<div class="col-lg-4 text-lg-end">
			<a class="btn <?php echo esc_attr($btnclass) ?>" href="<?php echo esc_url($button_url) ?>"><?php echo esc_attr($button_text); ?><i class="icon-arrows-slim-right"></i></a>
		</div>
	</div><!-- .row -->
</div>