<?php
extract(shortcode_atts(array(
	'posts_per_page' => -1, 
	'title_heading' => esc_attr__( 'Job Title', 'investment' ),
	'location_heading' => esc_attr__( 'Location', 'investment' ),
	'department_heading' => esc_attr__( 'Department', 'investment' ),
	'type_heading' => esc_attr__( 'Job type', 'investment' ),
	'sallary_heading' => esc_attr__( 'Sallary', 'investment' ),
	'vacancy_heading' => esc_attr__( 'Vacancy', 'investment' ),
	'date_heading' => esc_attr__( 'Post date', 'investment' ),
	'display_location' => 'yes',	
	'display_department' => 'yes',
	'display_type' => '',
	'display_sallary' => '',
	'display_vacancy' => '',
	'display_date' => 'yes',
), $args));
?>

<?php
$query_args = array(
		'post_type' => 'job',
		'posts_per_page' => intval($posts_per_page),
	);
// The Query
$the_query = new WP_Query( $query_args );

// The Loop
if ( $the_query->have_posts() ) : 
	wp_enqueue_style( 'investment-tablesorter' );
	wp_enqueue_script( 'jquery-tablesorter-widgets' );
	?>
	<table id="myTable" class="tablesorter investment-table table table-responsive table-striped mb-30">
		<thead class="table-light">
		   <tr>			   
			  	<th><?php echo esc_attr( $title_heading); ?></th>
			  	<?php echo !empty( $display_location )? '<th>'.esc_attr( $location_heading).'</th>' : '' ?>
			  	<?php echo !empty( $display_department )? '<th>'.esc_attr( $department_heading).'</th>' : '' ?>

			  	<?php echo !empty( $display_type )? '<th>'.esc_attr( $type_heading).'</th>' : '' ?>
				<?php echo !empty( $display_sallary )? '<th>'.esc_attr( $sallary_heading).'</th>' : '' ?>
				<?php echo !empty( $display_vacancy )? '<th>'.esc_attr( $vacancy_heading).'</th>' : '' ?>

			  	<?php echo !empty( $display_date )? '<th>'.esc_attr( $date_heading).'</th>' : '' ?>
		   </tr>
		</thead>
		<tbody>
			<?php
			while ( $the_query->have_posts() ) : 
				$the_query->the_post();
				$department = get_post_meta( get_the_ID(), 'department', true );

				$location = get_post_meta( get_the_ID(), 'location', true );
				$location_input = !empty($location['input'])? esc_attr( $location['input'] ) : '';

				$type = get_post_meta( get_the_ID(), 'type', true );
				$type_input = !empty($type['input'])? esc_attr( $type['input'] ) : '';

				$sallary_info = get_post_meta( get_the_ID(), 'sallary_info', true );
				$sallary_info_input = !empty($sallary_info['input'])? esc_attr( $sallary_info['input'] ) : '';

				$vacancy = get_post_meta( get_the_ID(), 'vacancy', true );
				$vacancy_input = !empty($vacancy['input'])? esc_attr( $vacancy['input'] ) : '';
				?>
				<tr>
					<td><a href="<?php the_permalink() ?>"><?php the_title() ?></a></td>
					<?php echo !empty( $display_location )? '<td>'.esc_attr( $location_input).'</td>' : '' ?>
					<?php echo !empty( $display_department )? '<td>'.esc_attr( $department).'</td>' : '' ?>

					<?php echo !empty( $display_type )? '<td>'.esc_attr( $type_input).'</td>' : '' ?>
					<?php echo !empty( $display_sallary )? '<td>'.esc_attr( $sallary_info_input).'</td>' : '' ?>
					<?php echo !empty( $display_vacancy )? '<td>'.esc_attr( $vacancy_input).'</td>' : '' ?>

					<?php echo !empty( $display_date )? '<td>'.esc_attr( get_the_date()).'</td>' : '' ?>
				</tr>			
			<?php endwhile; ?>
		</tbody>
		<?php wp_reset_postdata();	?>		
	</table>	
<?php endif; ?>