<?php
extract(wp_parse_args($args, array(
	'lead_text_align' => '',
	'lead_text' => '<b>Founded in 1980,</b> Investment Expert is one of the largest and most experienced global private equity firms. We have established a team investment professionals, focused on buyouts and growth equity investments.',
    'type' => 'no',
    'hide_value' => 'no',
    'hide_label' => 'no',
    'label_title' => 'Middle-market private equity',
    'label_large' => 'EWT',
    'label_desc' => '{12} Offices in {11} Countries',
    'value_title' => 'Invested',
    'value_large' => '$2.4',
    'value_unit' => 'B',
    'horizontal_gap' => '5'
)));
$class = 'col';
?>
<div class="company-summary bg-white text-body">
    <div class="row gx-<?php echo $horizontal_gap ?>">
        <div class="col-lg-8">
            <div class="company-history px-30 px-lg-45 pt-40 pb-20">
                <div class="row row-cols-1 row-cols-lg-2 gx-30">
                    <?php if( $lead_text != '' ): ?>
                        <div class="<?php echo esc_attr($class) ?>">
                            <p class="lead <?php echo esc_attr($lead_text_align) ?>"><?php echo force_balance_tags($lead_text); ?></p>
                        </div>                   
                    <?php endif; ?>
                    <div class="<?php echo esc_attr($class) ?> p-grey">
                        <?php echo wpautop($content, true) ?>	
                    </div>	
                </div>
            </div>    
        </div>
        <div class="col-lg-4">
            <div class="bg-primary text-white h-100 d-grid">
                <?php if( $hide_label == 'no' || empty($hide_label)): ?>
                <div class="company-info d-flex align-items-start ps-65 pe-20 pt-40">
                    <div class="icon-wrap">
                        <i class="icon-arrows-slim-right icon-arrows-large ms-n65"></i>
                    </div>
                    <div class="company-info-txt">
                        <h5 class="h5-sm mb-0"><?php echo esc_attr($label_title) ?></h5>
                        <span class="display-1 fw-bold"><?php echo esc_attr($label_large) ?></span>
                        <p class="mb-0"><?php echo investment_parse_text(esc_attr($label_desc), 'b') ?></p>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if( $hide_value == 'no' || empty($hide_value)): ?>
                <div class="company-info align-self-end d-flex  align-items-start bg-tra-black ps-65 pe-20 py-30 mt-30">
                    <div class="icon-wrap">
                        <i class="icon-arrows-slim-right icon-arrows-large ms-n65"></i>
                    </div>
                    <div class="company-info-txt">
                        <h5 class="h5-sm mb-0"><?php echo esc_attr($value_title) ?></h5>
                        <span class="display-1 fw-bold"><?php echo esc_attr($value_large) ?> <span class="smaller"><?php echo esc_attr($value_unit) ?></span></span>
                    </div>
                </div>	
                <?php endif; ?>
            </div>
        </div>
    </div>	
</div>