<?php

extract(shortcode_atts(array(
	'image' => '',
    'title' => 'Get in Touch',
    'address' => '70 W. Madison Street, Ste. 1400 Chicago, IL 60602',
    'phone' => '(214) 550-0405',
    'fax' => '(290) 580-9595',
    'email' => 'info@themeperch.net',
    'list_info' => [],
), $args));
?>

<div class="get-touch">
	<h4 class="border-title"><?php echo esc_attr($title) ?></h4>
	<?php 
	if( $image != '' ){
		echo wp_get_attachment_image( $image, 'investment--x125-crop' );
	} 
	?>
	<p class="normal"><?php echo force_balance_tags(nl2br($address)) ?></p>
	<ul class="list-unstyled">
		<?php
			if( $phone != '' ){
			$phoneArr = explode(',', $phone);
			foreach ($phoneArr as $key => $value) {
				echo '<li><a href="tel:'.esc_attr($value).'" class="h_small"><i class="text-primary perch-Phone2"></i> '.esc_attr($value).'</a></li>';
			}
		}

		if( $fax != '' ){
			$faxArr = explode(',', $fax);
			foreach ($faxArr as $key => $value) {
				echo '<li><a href="#" class="h_small"><i class="text-primary perch-Printer"></i> '.esc_attr($value).'</a></li>';
			}
		}

		if( $email != '' ){
			$emailArr = explode(',', $email);
			foreach ($emailArr as $key => $value) {
				echo '<li><a href="mailto:'.esc_attr($value).'" class="h_small"><i class="text-primary perch-Inbox"></i> '.esc_attr($value).'</a></li>';
			}
		}
		?>
	</ul>
	<?php
		
	if( !empty(array_filter($list_info)) ):
		echo '<ul class="contact-list-info">';
		foreach ($list_info as $key => $value) {
			echo ( $value['list_title'] != '' )?'<li><h4 class="h4_small underline-primary">'.esc_attr($value['list_title']).'</h4>
				<span class="h_small">'.str_replace(',', '</span><span class="h_small">', $value['list_info']).'</span>
				</li>' : '';
		}
		echo '</ul>';
	endif; 
	?>
</div>