<?php

extract(shortcode_atts(array(
	'bg_type' => 'bg_gray',
	'add_custom_image' => 'no',
	'image' => '',
	'image_right' => 'order-0',
	'tag' => 'h4',
	'title' => 'Increase Profitability', 
	'add_underline' => 'yes',
	'style' => 'underline_small',
	'content' => ''
), $args));

$class = ( $add_underline == 'yes' )? $style : '';
$image_url = ( $add_custom_image == 'yes' )? $image : get_the_post_thumbnail_url( get_the_ID(), 'full' );
$image_alt = ( $add_custom_image == 'yes' )? $title : get_the_title();

?>
<div class="increase-rofitability <?php echo esc_attr($bg_type) ?>"  data-equal=".feature-height">
	<div class="row d-lg-flex align-items-center">
		<?php if(!empty($image_url)): ?>
		<div class="col-lg-6 col-sm-6 <?php echo esc_attr($image_right) ?>">
			<div class="increase-rofitability-holder">				
				<img src="<?php echo esc_url($image_url) ?>" class="img-fluid" alt="<?php esc_attr($image_alt); ?>">			
			</div>
		</div><!-- .col-lg-6 -->
		<?php endif ?>
		<div class="col order-sm-1">
			<div class="increase-rofitability-text">
				<<?php echo esc_attr($tag) ?> class="featured-title <?php echo esc_attr($class) ?>">
					<?php echo investment_parse_text(esc_attr($title)) ?>
				</<?php echo esc_attr($tag) ?>>
				<div class='normal'>
					<?php echo wp_kses_post($content) ?>
				</div>
			</div>
		</div><!-- .col-lg-6 -->								
	</div><!-- .row -->
</div>