<?php

extract(shortcode_atts(array(
    'type' => 'no',
    'label_title' => 'Middle-market private equity',
    'label_large' => 'EWT',
    'label_desc' => '{12} Offices in {11} Countries',
    'value_title' => 'Invested',
    'value_large' => '$2.4',
    'value_unit' => 'B',
    'hide_value' => 'no',
    'hide_label' => 'no',
), $args));
$class = ($type == 'yes')? 'col-lg-6' : 'col-lg-12';
?>
<div class="figures-block bg-primary text-white row"<?php echo ($type == 'yes')? ' data-equal=".ewt-height"' : ''  ?>>
	<?php if( $hide_label == 'no' || empty($hide_label)): ?>
	<div class="<?php echo esc_attr($class) ?>">		
		<div class="pt-25 ps-60 pb-30">
			<i class="icon-arrows-slim-right"></i>
			<h5><?php echo esc_attr($label_title) ?></h5>
			<span class="big-title white"><?php echo esc_attr($label_large) ?></span>
			<p><?php echo investment_parse_text(esc_attr($label_desc), 'strong') ?></p>
		</div>		
	</div>
	<?php endif; ?>
	
	<?php if( $hide_value == 'no' || empty($hide_value) ): ?>
	<div class="<?php echo esc_attr($class) ?>">		
		<div class="pt-25 ps-60 pb-60 invested">
			<i class="icon-arrows-slim-right"></i>
			<h5><?php echo esc_attr($value_title) ?></h5>
			<span class="big-title"><?php echo esc_attr($value_large) ?> <span><?php echo esc_attr($value_unit) ?></span></span>
		</div>
	</div>
	<?php endif; ?>
</div>