<?php

extract(shortcode_atts(array(
	'style' => 'style1',
	'align' => 'text-left',
	'title_tag' => '',
	'title_font_size' => '',
	'title' => 'Investment Expert is one of the largest and most experienced global private equity investors', 
	'subtitle' => 'Middle-market private equity',
	'desc' => '',
	'button_text' => 'Find out more',
	'button_url' => '#',

), $args));

?>
<div class="header-content header-content-<?php echo esc_attr($style) ?> <?php echo esc_attr($align) ?>">
	<?php if( $style == 'style1' ): ?>
			<?php if( $subtitle != '' ): ?>
				<span class="caps_large underline-primary fs-6">
					<?php echo investment_parse_text(force_balance_tags($subtitle)) ?>
				</span>
			<?php endif; ?>

			<?php if( $title != '' ): 
				$title_tag = empty($title_tag) ? 'h3' : $title_tag;
				$title_size = empty($title_font_size) ? 'fs-1' : $title_font_size;
				?>
				<<?php echo $title_tag ?> class="<?php echo $title_size ?>">
					<?php echo investment_parse_text(force_balance_tags($title)) ?>
				</<?php echo $title_tag ?>>
			<?php endif; ?>
			
	<?php elseif( $style == 'style2' ): ?>
			<?php if( $subtitle != '' ): ?>
				<span class="smaller">
					<?php echo investment_parse_text(force_balance_tags($subtitle)) ?>
				</span>
			<?php endif; ?>

			<?php if( $title != '' ): 
				$title_tag = empty($title_tag) ? 'h2' : $title_tag;
				$title_size = empty($title_font_size) ? 'display-4' : $title_font_size;
				?>
				<<?php echo $title_tag ?> class="<?php echo $title_size ?> fw-bold">
					<?php echo investment_parse_text(force_balance_tags($title)) ?>
				</<?php echo $title_tag ?>>
			<?php endif; ?>				
	<?php else: ?>
			<?php if( $subtitle != '' ): ?>
				<h6>
					<?php echo investment_parse_text(force_balance_tags($subtitle)) ?>
				</h6>
			<?php endif; ?>
			<?php if( $title != '' ): 
				$title_tag = empty($title_tag) ? 'span' : $title_tag;
				$title_size = empty($title_font_size) ? 'display-1' : $title_font_size;
				?>
				<<?php echo $title_tag ?> class="<?php echo $title_size ?> excerpt_normal fw-normal text-uppercase text-left underline-primary">
					<?php echo investment_parse_text(force_balance_tags($title)) ?>
				</<?php echo $title_tag ?>>
			<?php endif; ?>	
	<?php endif; ?>

	<?php if( $desc != '' ): ?>
		<p class="normal"><?php echo force_balance_tags($desc) ?></p>
	<?php endif; ?>

	<?php if( $button_text != '' ): ?>
		<div class="clear"></div>
		<p>
			<a href="<?php echo esc_url($button_url); ?>" class="btn btn-primary"><?php echo esc_attr($button_text) ?> <i class=" icon-arrows-slim-right"></i></a>
		</p>
	<?php endif; ?>
</div>